function [countDecisions, countLeftChosen] = Choices(valueDiffs, ...
    choice, valueLeft, valueRight, parcode, session, cisOnly, transOnly)

if exist('parcode', 'var') && exist('session', 'var')
    if ~exist('cisOnly', 'var')
        cisOnly = false;
    end
    if ~exist('transOnly', 'var')
        transOnly = false;
    end

    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    valueLeft = [];
    valueRight = [];
    choice = [];
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            distLeft = angTarget - data.left{numBlock}(numTrial);
            distRight = angTarget - data.right{numBlock}(numTrial);
            if distLeft * distRight > 0 && transOnly
                continue;
            end
            if distLeft * distRight < 0 && cisOnly
                continue;
            end
            valueLeft(trial,1) = - abs(distLeft);
            valueRight(trial,1) = - abs(distRight);
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            trial = trial + 1;
        end
    end
    fclose('all');
end

countDecisions = zeros(length(valueDiffs), 1);
countLeftChosen = zeros(length(valueDiffs), 1);

for numTrial=1:length(choice)
    valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    idx = find(valueDiffs==valueDiff);

    countDecisions(idx) = countDecisions(idx) + 1;
    if choice(numTrial) == -1 % chose left
        countLeftChosen(idx) = countLeftChosen(idx) + 1;
    end
end
end
