function [leftCountDecisions, leftCountLeftChosen, rightCountDecisions, ...
    rightCountLeftChosen] = ChoicesGroupedByFirstFixation(valueDiffs, ...
    choice, fixItem, valueLeft, valueRight, parcode, session, cisOnly, ...
    transOnly)

if exist('parcode', 'var') && exist('session', 'var')
    if ~exist('cisOnly', 'var')
        cisOnly = false;
    end
    if ~exist('transOnly', 'var')
        transOnly = false;
    end

    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [~, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    valueLeft = [];
    valueRight = [];
    choice = [];
    fixItem = {};
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            distLeft = angTarget - data.left{numBlock}(numTrial);
            distRight = angTarget - data.right{numBlock}(numTrial);
            if distLeft * distRight > 0 && transOnly
                continue;
            end
            if distLeft * distRight < 0 && cisOnly
                continue;
            end
            valueLeft(trial,1) = - abs(distLeft);
            valueRight(trial,1) = - abs(distRight);
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

% Get first fixated item of each trial.
firstFixatedItem = zeros(length(fixItem), 1);

for numTrial = 1:length(fixItem)
    for i = 1:length(fixItem{numTrial})
        if fixItem{numTrial}(i) == 1 % first item is LEFT
            firstFixatedItem(numTrial) = 1;
            break;
        elseif fixItem{numTrial}(i) == 2 % first item is RIGHT
            firstFixatedItem(numTrial) = 2;
            break;
        end
    end
end

leftCountDecisions = zeros(length(valueDiffs), 1);
leftCountLeftChosen = zeros(length(valueDiffs), 1);
rightCountDecisions = zeros(length(valueDiffs), 1);
rightCountLeftChosen = zeros(length(valueDiffs), 1);

for numTrial = 1:length(choice)
    valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    idx = find(valueDiffs==valueDiff);

    % Add trial based on first fixated item and on decision.
    if firstFixatedItem(numTrial) == 1 % 1st fixated LEFT
        leftCountDecisions(idx) = leftCountDecisions(idx) + 1;
        if choice(numTrial) == -1
            leftCountLeftChosen(idx) = leftCountLeftChosen(idx) + 1;
        end
    elseif firstFixatedItem(numTrial) == 2 % 1st fixated RIGHT
        rightCountDecisions(idx) = rightCountDecisions(idx) + 1;
        if choice(numTrial) == -1
            rightCountLeftChosen(idx) = rightCountLeftChosen(idx) + 1;
        end
    end
end
end
