function [countDecisions, countLeftChosen] = ...
    ChoicesGroupedByTargetRecency(parcode, sessn, valueDiffs, recencies)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

countDecisions = cell(length(recencies),1);
countLeftChosen = cell(length(recencies),1);
for i=1:length(recencies)
    countDecisions{i} = zeros(length(valueDiffs), 1);
    countLeftChosen{i} = zeros(length(valueDiffs), 1);
end

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);

    for numTrial = 1:data.numTestTrials
        trialRecency = mod(numTrial-1, length(recencies));
        recencyIdx = find(recencies==trialRecency);
        
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueDiff = valueLeft - valueRight;
        diffIdx = find(valueDiffs==valueDiff);
        
        countDecisions{recencyIdx}(diffIdx) = ...
            countDecisions{recencyIdx}(diffIdx) + 1;
        
        responseType = data.testResponseType{numBlock}(numTrial);
        if responseType == -1 % chose left
            countLeftChosen{recencyIdx}(diffIdx) = ...
                countLeftChosen{recencyIdx}(diffIdx) + 1;
        end
    end
end
end
