function [leftCountDecisions, leftCountLeftChosen, rightCountDecisions, ...
    rightCountLeftChosen] = ChoicesGroupedByTotalFixation(valueDiffs, ...
    choice, fixItem, fixTime, valueLeft, valueRight, parcode, session, ...
    cisOnly, transOnly)

if exist('parcode', 'var') && exist('session', 'var')
    if ~exist('cisOnly', 'var')
        cisOnly = false;
    end
    if ~exist('transOnly', 'var')
        transOnly = false;
    end

    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    valueLeft = [];
    valueRight = [];
    choice = [];
    fixItem = {};
    fixTime = {};
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            distLeft = angTarget - data.left{numBlock}(numTrial);
            distRight = angTarget - data.right{numBlock}(numTrial);
            if distLeft * distRight > 0 && transOnly
                continue;
            end
            if distLeft * distRight < 0 && cisOnly
                continue;
            end
            valueLeft(trial,1) = - abs(distLeft);
            valueRight(trial,1) = - abs(distRight);
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

% Group trials based on whether they had more left or right fixation.
mostFixatedItem = zeros(length(fixItem), 1);

for numTrial = 1:length(fixItem)
    timeLeftFix = 0;
    timeRightFix = 0;

    for i = 1:length(fixItem{numTrial})
        if fixItem{numTrial}(i) == 1 % left item fixation
            timeLeftFix = timeLeftFix + fixTime{numTrial}(i);
        elseif fixItem{numTrial}(i) == 2 % right item fixation
            timeRightFix = timeRightFix + fixTime{numTrial}(i);
        end
    end

    if timeLeftFix > timeRightFix
        mostFixatedItem(numTrial) = 1; % 1 for LEFT
    elseif timeLeftFix < timeRightFix
        mostFixatedItem(numTrial) = 2; % 2 for RIGHT
    else
        mostFixatedItem(numTrial) = 0; % 0 otherwise
    end
end

leftCountDecisions = zeros(length(valueDiffs), 1);
leftCountLeftChosen = zeros(length(valueDiffs), 1);
rightCountDecisions = zeros(length(valueDiffs), 1);
rightCountLeftChosen = zeros(length(valueDiffs), 1);

for numTrial = 1:length(fixItem)
    valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    idx = find(valueDiffs==valueDiff);

    % Add trial based on most fixated item and on decision.
    if mostFixatedItem(numTrial) == 1 % fixated LEFT
        leftCountDecisions(idx) = leftCountDecisions(idx) + 1;
        if choice(numTrial) == -1
            leftCountLeftChosen(idx) = leftCountLeftChosen(idx) + 1;
        end
    elseif mostFixatedItem(numTrial) == 2 % fixated RIGHT
        rightCountDecisions(idx) = rightCountDecisions(idx) + 1;
        if choice(numTrial) == -1
            rightCountLeftChosen(idx) = rightCountLeftChosen(idx) + 1;
        end
    end
end
end
