function [countDecisions, countLeftChosen] = ...
    ChoicesGroupedByTrialType(parcode, sessn, orientations)

% Each trial type corresponds to a particular distance between target and
% left stimulus and a particular distance between target and right
% stimulus.

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Group trials based on orientation of both stimuli.
countDecisions = zeros(length(orientations), length(orientations));
countLeftChosen = zeros(length(orientations), length(orientations));

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);

    for numTrial = 1:data.numTestTrials
        % Calculate distance from target for left and right stimuli.
        angLeft = data.left{numBlock}(numTrial);
        distLeft = angTarget - angLeft;
        angRight = data.right{numBlock}(numTrial);
        distRight = angTarget - angRight;
        
        row = find(orientations==distLeft);
        col = find(orientations==distRight);
        
        % Add trial based on decision.
        countDecisions(row,col) = countDecisions(row,col) + 1;
        if data.testResponseType{numBlock}(numTrial) == -1 % chose left
            countLeftChosen(row,col) = countLeftChosen(row,col) + 1;
        end
       
    end
end
end
