function [choice, rt, valueLeft, valueRight, fixItem, fixTime] = ...
    ConvertSimulationsCsvFiles(expdataFile, fixationsFile)

choice = [];
rt = [];
valueLeft = [];
valueRight = [];
fixItem = {};
fixTime = {};

expdata = dlmread(expdataFile, ',', 1, 0);
fixations = dlmread(fixationsFile, ',', 1, 0);

currFix = 1;
trialCount = 1;
for i = 1:size(expdata, 1)
    currTrial = expdata(i, 2);
    rt = [rt; expdata(i, 3)];
    choice = [choice; expdata(i, 4)];
    valueLeft = [valueLeft; expdata(i, 5)];
    valueRight = [valueRight; expdata(i, 6)];
    
    trialFixItem = [];
    trialFixTime = [];
    while true
        if currFix <= size(fixations,1)
            if fixations(currFix, 2) == currTrial
                trialFixItem = [trialFixItem; fixations(currFix, 3)];
                trialFixTime = [trialFixTime; fixations(currFix, 4)];
                currFix = currFix + 1;
            else
                break
            end
        else
            break
        end
    end
    fixItem{trialCount, 1} = trialFixItem;
    fixTime{trialCount, 1} = trialFixTime;
    trialCount = trialCount + 1;
end

fclose('all');
end