function corrProbs = CorrProbChooseFirstFixVsTimeFirstFix( ...
    timeBins, valueDiffs, avgProbs, choice, fixItem, fixTime, ...
    valueLeft, valueRight, parcode, session, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            distLeft = angTarget - data.left{numBlock}(numTrial);
            distRight = angTarget - data.right{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(distLeft);
            valueRight(trial,1) = - abs(distRight);
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

corrProbs = cell(length(timeBins), 1);

for trial=1:length(choice)
    timeFirstFix = 0;
    firstFixItem = 0;
    for i = 1:length(fixItem{trial})
        if fixItem{trial}(i) == 1 % left item fixation
            timeFirstFix = fixTime{trial}(i);
            firstFixItem = -1;
            break;
        elseif fixItem{trial}(i) == 2 % right item fixation
            timeFirstFix = fixTime{trial}(i);
            firstFixItem = 1;
            break;
        end
    end
    if firstFixItem == 0
        continue;
    end

    % Get first fix time bin.
    bin = 1;
    for i=1:length(timeBins)-1
        if timeFirstFix >= timeBins(i) && timeFirstFix < timeBins(i+1)
            bin = i;
            break;
        end
    end
    if timeFirstFix >= timeBins(end)
        bin = length(timeBins);
    end
    
    % Get index based on value difference.
    if firstFixItem == -1
        vDiff = valueLeft(trial) - valueRight(trial);
    elseif firstFixItem == 1
        vDiff = valueRight(trial) - valueLeft(trial);
    end
%     vDiff = valueLeft(trial) - valueRight(trial);
    idx = find(valueDiffs==vDiff);

    % Check decision.
    if choice(trial) == firstFixItem
        prob = 1 - avgProbs(idx);
    else
        prob = 0 - avgProbs(idx);
    end
    corrProbs{bin} = [corrProbs{bin}; prob];
end
end