function [countDecisions, countCorrect] = ...
    CorrectGroupedByValueDiff(parcode, sessn, valueDiffs)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Group trials based on orientation of both stimuli.
countDecisions = zeros(length(valueDiffs), 1);
countCorrect = zeros(length(valueDiffs), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);

    for numTrial = 1:data.numTestTrials
        % Calculate distance from target for left and right stimuli.
        angLeft = data.left{numBlock}(numTrial);
        distLeft = angTarget - angLeft;
        valueLeft = - abs(distLeft);
        angRight = data.right{numBlock}(numTrial);
        distRight = angTarget - angRight;
        valueRight = - abs(distRight);
        
        valueDiff = valueLeft - valueRight;
        idx = find(valueDiffs==valueDiff);

        % Add trial based on decision.
        countDecisions(idx,1) = countDecisions(idx,1) + 1;
        if data.testResponseType{numBlock}(numTrial) == -1 && ...
            valueLeft >= valueRight % chose left and was correct
            countCorrect(idx,1) = countCorrect(idx,1) + 1;
        elseif data.testResponseType{numBlock}(numTrial) == 1 && ...
            valueRight >= valueLeft % chose right and was correct
            countCorrect(idx,1) = countCorrect(idx,1) + 1;
        end
       
    end
end
end
