clear
close all
clc

parcodes = ['mar'; 'sol'; 'lua'; 'rio'; 'cor'; 'sal'; 'mel'; 'dia'; ...
    'ceu'; 'lei'; 'fio'; 'sul'; 'vai'; 'pai'; 'reu'; 'cai'; 'rei'; ...
    'dor'; 'giz'; 'mae'; 'tia'; 'pia'; 'fui'; 'gol'; 'gel'];
sessions = 1:4;

earlyMemoryTrialsOnly = false;
lateMemoryTrialsOnly = true;

fileIdExp = fopen('expdata.csv','w');
fprintf(fileIdExp, 'parcode,trial,rt,choice,item_left,item_right,valid\n');

fileIdFix = fopen('fixations.csv','w');
fprintf(fileIdFix, 'parcode,trial,fix_item,fix_time\n');

for p=1:length(parcodes)
    trial = 0;
    for s=sessions
        % Load experimental data.
        files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', ...
            parcodes(p,:), s));
        load(sprintf('expdata/%s', files(1).name));

        % Load eye tracking data.
        [fixTime, ~, ~, fixItem, trialDuration, transitionTime] = ...
            ReadEyetrackingData(parcodes(p,:), s);

        for numBlock = 1:data.numBlocks
            angTarget = data.target(numBlock);
            for numTrial = 1:data.numTestTrials
                
                if earlyMemoryTrialsOnly && ...
                        ~(mod(numTrial-1,5)==0 || mod(numTrial-2,5)==0)
                    continue;
                end
                if lateMemoryTrialsOnly && ...
                        ~(mod(numTrial-4,5)==0 || mod(numTrial,5)==0)
                    continue;
                end

                % Determine participant code.
                parcode = parcodes(p,:);
                
                % Determine RT.
                rt = trialDuration(numBlock, numTrial);

                % Determine choice.
                choice = data.testResponseType{numBlock}(numTrial);
                
                % Calculate distance from target for each stimulus.
                angLeft = data.left{numBlock}(numTrial);
                dist_left = angTarget - angLeft;

                angRight = data.right{numBlock}(numTrial);
                dist_right = angTarget - angRight;

                % Check if trial is valid.
                if (transitionTime(numBlock,numTrial) / ...
                        trialDuration(numBlock, numTrial)) >= 0.6
                    continue;
                end
                if isempty(find(fixItem{numBlock,numTrial}==1 | ...
                        fixItem{numBlock,numTrial}==2, 1))
                    continue;
                end

                for i=1:length(fixItem{numBlock,numTrial})
                    fprintf(fileIdFix, '%s,%d,%d,%f\n', parcode, ...
                        trial, fixItem{numBlock,numTrial}(i), ...
                        fixTime{numBlock,numTrial}(i));
                end
                
                fprintf(fileIdExp, '%s,%d,%f,%d,%d,%d\n', parcode, ...
                    trial, rt, choice, dist_left, dist_right);

                trial = trial + 1;
            end
        end
    end
end

fclose('all');
