function [firstFixTimes, secondFixTimes, thirdFixTimes, fourthFixTimes, ...
    fifthFixTimes, sixthFixTimes, seventhFixTimes, eighthFixTimes, ...
    ninthFixTimes, tenthFixTimes, otherFixTimes] = ...
    FixationDurationGroupedByType(parcode, session)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Load eye tracking data.
[fixTime, ~, ~, fixItem, ~] = ReadEyetrackingData(parcode, session);

selectFixItem = cell(size(fixItem));
selectFixTime = cell(size(fixTime));

% Select only fixations to right or left item.
for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        idx = find(fixItem{numBlock,numTrial} == 1 | ...
            fixItem{numBlock,numTrial} == 2);
        selectFixTime{numBlock,numTrial} = fixTime{numBlock,numTrial}(idx);
        selectFixItem{numBlock,numTrial} = fixItem{numBlock,numTrial}(idx);
    end
end

firstFixTimes = [];
secondFixTimes = [];
thirdFixTimes = [];
fourthFixTimes = [];
fifthFixTimes = [];
sixthFixTimes = [];
seventhFixTimes = [];
eighthFixTimes = [];
ninthFixTimes = [];
tenthFixTimes = [];
otherFixTimes = [];

for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        if length(selectFixItem{numBlock,numTrial}) < 2
            continue;
        end
        % Get first fixation.
        firstFixTimes = [firstFixTimes; ...
            selectFixTime{numBlock,numTrial}(1)];

        if length(selectFixItem{numBlock,numTrial}) < 3
            continue;
        end
        % Get second fixation.
        secondFixTimes = [secondFixTimes; ...
            selectFixTime{numBlock,numTrial}(2)];

        if length(selectFixItem{numBlock,numTrial}) < 4
            continue;
        end
        % Get third fixation.
        thirdFixTimes = [thirdFixTimes; ...
            selectFixTime{numBlock,numTrial}(3)];

        if length(selectFixItem{numBlock,numTrial}) < 5
            continue;
        end
        % Get fourth fixation.
        fourthFixTimes = [fourthFixTimes; ...
            selectFixTime{numBlock,numTrial}(4)];

        if length(selectFixItem{numBlock,numTrial}) < 6
            continue;
        end
        % Get fifth fixation.
        fifthFixTimes = [fifthFixTimes; ...
            selectFixTime{numBlock,numTrial}(5)];

        if length(selectFixItem{numBlock,numTrial}) < 7
            continue;
        end
        % Get sixth fixation.
        sixthFixTimes = [sixthFixTimes; ...
            selectFixTime{numBlock,numTrial}(6)];

        if length(selectFixItem{numBlock,numTrial}) < 8
            continue;
        end
        % Get seventh fixation.
        seventhFixTimes = [seventhFixTimes; ...
            selectFixTime{numBlock,numTrial}(7)];

        if length(selectFixItem{numBlock,numTrial}) < 9
            continue;
        end
        % Get eighth fixation.
        eighthFixTimes = [eighthFixTimes; ...
            selectFixTime{numBlock,numTrial}(8)];
        
        if length(selectFixItem{numBlock,numTrial}) < 10
            continue;
        end
        % Get ninth fixation.
        ninthFixTimes = [ninthFixTimes; ...
            selectFixTime{numBlock,numTrial}(9)];
        
        if length(selectFixItem{numBlock,numTrial}) < 11
            continue;
        end
        % Get tenth fixation.
        tenthFixTimes = [tenthFixTimes; ...
            selectFixTime{numBlock,numTrial}(10)];
        
        if length(selectFixItem{numBlock,numTrial}) < 12
            continue;
        end
        % Get all other fixations, except the last one.
        for i=11:length(selectFixTime{numBlock,numTrial})-1
            otherFixTimes = [otherFixTimes; ...
                selectFixTime{numBlock,numTrial}(i)];
        end
    end
end
end
