function [firstFixTimeValFix, firstFixTimeValNonFix, ...
    lastFixTimeValFix, lastFixTimeValNonFix, middleFixTimeValFix, ...
    middleFixTimeValNonFix] = FixationDurationVsItemValue(parcode, ...
    sessn, values, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Load eye tracking data.
[fixTime, ~, ~, fixItem, ~] = ReadEyetrackingData(parcode, sessn);

selectFixTime = cell(data.numBlocks, data.numTestTrials);
selectFixItem = cell(data.numBlocks, data.numTestTrials);

% Select only fixations to right or left item
for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        idx = find(fixItem{numBlock,numTrial} == 1 | ...
            fixItem{numBlock,numTrial} == 2);
        selectFixTime{numBlock,numTrial} = fixTime{numBlock,numTrial}(idx);
        selectFixItem{numBlock,numTrial} = fixItem{numBlock,numTrial}(idx);
    end
end

firstFixTimeValFix = cell(length(values), 1);
firstFixTimeValNonFix = cell(length(values), 1);
lastFixTimeValFix = cell(length(values), 1);
lastFixTimeValNonFix = cell(length(values), 1);
middleFixTimeValFix = cell(length(values), 1);
middleFixTimeValNonFix = cell(length(values), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        if mod(numTrial,2) == 0 && oddTrialsOnly
            continue;
        end
        if mod(numTrial,2) == 1 && evenTrialsOnly
            continue;
        end

        % Calculate values of fixated and non-fixated items in this trial.
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        valueLeft = (valueLeft / 5) + 3;
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueRight = (valueRight / 5) + 3;
        
        if length(selectFixItem{numBlock,numTrial}) <= 1
            continue;
        end

        % Values for first fixation.
        if selectFixItem{numBlock,numTrial}(1) == 1 % LEFT
            valueFix = valueLeft;
            valueNonFix = valueRight;
        else % RIGHT
            valueFix = valueRight;
            valueNonFix = valueLeft;
        end
        idxFirstFix = find(values==valueFix);
        idxFirstNonFix = find(values==valueNonFix);

        len = length(selectFixTime{numBlock,numTrial});

        % Values for last fixation.
        if selectFixItem{numBlock,numTrial}(len) == 1 % LEFT
            valueFix = valueLeft;
            valueNonFix = valueRight;
        else % RIGHT
            valueFix = valueRight;
            valueNonFix = valueLeft;
        end
        idxLastFix = find(values==valueFix);
        idxLastNonFix = find(values==valueNonFix);

        % Values for middle fixations.
        idxsMiddleFix = [];
        idxsMiddleNonFix = [];
        middleFixTimes = [];
        for i = 2:(len - 1)
            if selectFixItem{numBlock,numTrial}(i) == 1 % LEFT
                valueFix = valueLeft;
                valueNonFix = valueRight;
                else % RIGHT
                valueFix = valueRight;
                valueNonFix = valueLeft;
            end
            idxFix = find(values==valueFix);
            idxsMiddleFix = [idxsMiddleFix; idxFix];
            idxNonFix = find(values==valueNonFix);
            idxsMiddleNonFix = [idxsMiddleNonFix; idxNonFix];
            timeFix = selectFixTime{numBlock,numTrial}(i);
            middleFixTimes = [middleFixTimes; timeFix];
        end

        % Get first fixation duration.
        firstFixTimeValFix{idxFirstFix} = ...
            [firstFixTimeValFix{idxFirstFix}; ...
            selectFixTime{numBlock,numTrial}(1)];
        firstFixTimeValNonFix{idxFirstNonFix} = ...
            [firstFixTimeValNonFix{idxFirstNonFix}; ...
            selectFixTime{numBlock,numTrial}(1)];

        % Get last fixation duration.
        lastFixTimeValFix{idxLastFix} = ...
            [lastFixTimeValFix{idxLastFix}; ...
            selectFixTime{numBlock,numTrial}(len)];
        lastFixTimeValNonFix{idxLastNonFix} = ...
            [lastFixTimeValNonFix{idxLastNonFix}; ...
            selectFixTime{numBlock,numTrial}(len)];

        % Get middle fixations durations.
        for i = 1:length(idxsMiddleFix)
            middleFixTimeValFix{idxsMiddleFix(i)} = ...
                [middleFixTimeValFix{idxsMiddleFix(i)}; ...
                middleFixTimes(i)];
            middleFixTimeValNonFix{idxsMiddleNonFix(i)} = ...
                [middleFixTimeValNonFix{idxsMiddleNonFix(i)}; ...
                middleFixTimes(i)];
        end
    end
end
end
