function [firstFixTimeValLeft, firstFixTimeValRight, ...
    lastFixTimeValLeft, lastFixTimeValRight, middleFixTimeValLeft, ...
    middleFixTimeValRight] = FixationDurationVsLeftRight(parcode, ...
    sessn, values, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Load eye tracking data.
[fixTime, ~, ~, fixItem, ~] = ReadEyetrackingData(parcode, sessn);

selectFixTime = cell(data.numBlocks, data.numTestTrials);
selectFixItem = cell(data.numBlocks, data.numTestTrials);

% Select only fixations to right or left item
for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        idx = find(fixItem{numBlock,numTrial} == 1 | ...
            fixItem{numBlock,numTrial} == 2);
        selectFixTime{numBlock,numTrial} = fixTime{numBlock,numTrial}(idx);
        selectFixItem{numBlock,numTrial} = fixItem{numBlock,numTrial}(idx);
    end
end

firstFixTimeValLeft = cell(length(values), 1);
firstFixTimeValRight = cell(length(values), 1);
lastFixTimeValLeft = cell(length(values), 1);
lastFixTimeValRight = cell(length(values), 1);
middleFixTimeValLeft = cell(length(values), 1);
middleFixTimeValRight = cell(length(values), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        if mod(numTrial,2) == 0 && oddTrialsOnly
            continue;
        end
        if mod(numTrial,2) == 1 && evenTrialsOnly
            continue;
        end

        % Calculate values of left and right items in this trial.
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        valueLeft = (valueLeft / 5) + 3;
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueRight = (valueRight / 5) + 3;
        idxLeft = find(values==valueLeft);
        idxRight = find(values==valueRight);
        
        if length(selectFixItem{numBlock,numTrial}) <= 1
            continue;
        end

        % Values for first fixation.
        if selectFixItem{numBlock,numTrial}(1) == 1 % LEFT
            valueFix = valueLeft;
            valueNonFix = valueRight;
        else % RIGHT
            valueFix = valueRight;
            valueNonFix = valueLeft;
        end
        idxLeft = find(values==valueFix);
        idxRight = find(values==valueNonFix);

        % Get first fixation duration.
        firstFixTimeValLeft{idxLeft} = [firstFixTimeValLeft{idxLeft}; ...
            selectFixTime{numBlock,numTrial}(1)];
        firstFixTimeValRight{idxRight} = ...
            [firstFixTimeValRight{idxRight}; ...
            selectFixTime{numBlock,numTrial}(1)];

        % Get last fixation duration.
        lastFixTimeValLeft{idxLeft} = [lastFixTimeValLeft{idxLeft}; ...
            selectFixTime{numBlock,numTrial}(end)];
        lastFixTimeValRight{idxRight} = [lastFixTimeValRight{idxRight}; ...
            selectFixTime{numBlock,numTrial}(end)];

        % Get middle fixations durations.
        for i = 2:length(selectFixTime{numBlock,numTrial})-1
            middleFixTimeValLeft{idxLeft} = ...
                [middleFixTimeValLeft{idxLeft}; ...
                selectFixTime{numBlock,numTrial}(i)];
            middleFixTimeValRight{idxRight} = ...
                [middleFixTimeValRight{idxRight}; ...
                selectFixTime{numBlock,numTrial}(i)];
        end
    end
end
end
