function [firstFixTimes, secondFixTimes, otherFixTimes, lastFixTimes] = ...
    FixationDurationVsValueBestMinusWorst(valueDiffs, fixItem, fixTime, ...
    valueLeft, valueRight, parcode, session, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            angLeft = data.left{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(angTarget - angLeft);
            valueLeft(trial,1) = (valueLeft(trial,1) / 5) + 3;
            angRight = data.right{numBlock}(numTrial);
            valueRight(trial,1) = - abs(angTarget - angRight);
            valueRight(trial,1) = (valueRight(trial,1) / 5) + 3;
            
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

selectFixTime = cell(size(fixTime));

% Select only fixations to right or left item, which are between 10 and
% 3000 ms long.
for numTrial=1:length(fixItem)
    tempFixTime = fixTime{numTrial}(fixItem{numTrial} == 1 | ...
        fixItem{numTrial} == 2);
    selectFixTime{numTrial} = tempFixTime(tempFixTime >= 10 & ...
        tempFixTime <= 3000);
%     selectFixTime{numTrial} = tempFixTime;
end

firstFixTimes = cell(length(valueDiffs), 1);
secondFixTimes = cell(length(valueDiffs), 1);
otherFixTimes = cell(length(valueDiffs), 1);
lastFixTimes = cell(length(valueDiffs), 1);

for numTrial=1:length(selectFixTime)
    if length(selectFixTime{numTrial}) < 1
        continue;
    end

    % Get value difference.
    if valueLeft(numTrial) >= valueRight(numTrial)
        valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    else
        valueDiff = valueRight(numTrial) - valueLeft(numTrial);
    end
    idx = find(valueDiffs==valueDiff);

    % Get last fixation.
    lastFixTimes{idx} = [lastFixTimes{idx}; selectFixTime{numTrial}(end)];
 
    if length(selectFixTime{numTrial}) < 2
        continue;
    end
    % Get first fixation.
    firstFixTimes{idx} = [firstFixTimes{idx}; selectFixTime{numTrial}(1)];

    if length(selectFixTime{numTrial}) < 3
        continue;
    end
    % Get second fixation.
    secondFixTimes{idx} = [secondFixTimes{idx}; ...
        selectFixTime{numTrial}(2)];

    if length(selectFixTime{numTrial}) < 4
        continue;
    end
    % Get other fixations.
    for i=3:length(selectFixTime{numTrial})-1
        otherFixTimes{idx} = [otherFixTimes{idx}; ...
            selectFixTime{numTrial}(i)];
    end
end
end
