function [firstFixTimes, secondFixTimes, otherFixTimes, lastFixTimes] = ...
    FixationDurationVsValueFix(values, fixItem, fixTime, valueLeft, ...
    valueRight, parcode, session)

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    valueLeft = zeros(data.numBlocks * data.numTestTrials, 1);
    valueRight = zeros(data.numBlocks * data.numTestTrials, 1);
    fixItem = cell(data.numBlocks * data.numTestTrials, 1);
    fixTime = cell(data.numBlocks * data.numTestTrials, 1);
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            angLeft = data.left{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(angTarget - angLeft);
            angRight = data.right{numBlock}(numTrial);
            valueRight(trial,1) = - abs(angTarget - angRight);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

selectFixItem = cell(size(fixItem));
selectFixTime = cell(size(fixTime));

% Select only fixations to right or left item, which are between 10 and
% 3000 ms long.
for numTrial=1:length(fixItem)
    tempFixTime = fixTime{numTrial}(fixItem{numTrial} == 1 | ...
        fixItem{numTrial} == 2);
    tempFixItem = fixItem{numTrial}(fixItem{numTrial} == 1 | ...
        fixItem{numTrial} == 2);
    selectFixTime{numTrial} = tempFixTime(tempFixTime >= 10 & ...
        tempFixTime <= 3000);
    selectFixItem{numTrial} = tempFixItem(tempFixTime >= 10 & ...
        tempFixTime <= 3000);
end

firstFixTimes = cell(length(values), 1);
secondFixTimes = cell(length(values), 1);
otherFixTimes = cell(length(values), 1);
lastFixTimes = cell(length(values), 1);

for numTrial=1:length(selectFixItem)    
    if length(selectFixTime{numTrial}) < 1
        continue;
    end

    % Get last fixation.
    if selectFixItem{numTrial}(end) == 1 % last fixation left
        value = valueLeft(numTrial);
    elseif selectFixItem{numTrial}(end) == 2 % last fixation right
        value = valueRight(numTrial);
    end
    idx = find(values==value);
    lastFixTimes{idx} = [lastFixTimes{idx}; selectFixTime{numTrial}(end)];
    
    if length(selectFixItem{numTrial}) < 2
        continue;
    end
    % Get first fixation.
    if selectFixItem{numTrial}(1) == 1 % first fixation left
        value = valueLeft(numTrial);
    elseif selectFixItem{numTrial}(1) == 2 % first fixation right
        value = valueRight(numTrial);
    end
    idx = find(values==value);
    firstFixTimes{idx} = [firstFixTimes{idx}; selectFixTime{numTrial}(1)];

    if length(selectFixItem{numTrial}) < 3
        continue;
    end
    % Get second fixation.
    if selectFixItem{numTrial}(2) == 1 % second fixation left
        value = valueLeft(numTrial);
    elseif selectFixItem{numTrial}(2) == 2 % second fixation right
        value = valueRight(numTrial);
    end
    idx = find(values==value);
    secondFixTimes{idx} = [secondFixTimes{idx}; ...
        selectFixTime{numTrial}(2)];
    
    if length(selectFixItem{numTrial}) < 4
        continue;
    end
    % Get other fixations.
    for i=3:length(selectFixItem{numTrial})-1
        if selectFixItem{numTrial}(i) == 1 % other fixation left
            value = valueLeft(numTrial);
        elseif selectFixItem{numTrial}(i) == 2 % other fixation right
            value = valueRight(numTrial);
        end
        idx = find(values==value);
        otherFixTimes{idx} = [otherFixTimes{idx}; ...
            selectFixTime{numTrial}(i)];
    end
end
end
