close all
clear
clc

colors = distinguishable_colors(30);
cyan = colors(11,:);
pink = colors(5,:);
green = colors(13,:);
purple = colors(16,:);
magenta = colors(15,:);
yellow = colors(6,:);
alpha = 0.5;

values = 0:1:3;
valueDiffs = -3:1:3;
positiveplotValueDiffs = 1:1:3;
nonNegativeplotValueDiffs = 0:1:3;
xLim = [-3.5 3.5];

sessions = 1:4;
parcodes = ['mar'; 'sol'; 'lua'; 'rio'; 'cor'; 'sal'; 'mel'; 'dia'; ...
    'ceu'; 'lei'; 'fio'; 'sul'; 'vai'; 'pai'; 'reu'; 'cai'; 'rei'; ...
    'dor'; 'giz'; 'mae'; 'tia'; 'pia'; 'fui'; 'gol'; 'gel'];

plotsFileBaseName = 'fixation_plots';
clocknum = clock;
dateString = [];
for i=1:5
    dateString = [dateString '_' num2str(clocknum(i))];
end
plotsFileName = [plotsFileBaseName dateString];


%% Plot probability of fixating item first as a function of value
% difference.

aggregCountTotal = zeros(length(valueDiffs), 1);
aggregCountLeftFirst = zeros(length(valueDiffs), 1);
aggregCountRightFirst = zeros(length(valueDiffs), 1);

for i=1:length(parcodes)
    subjCountTotal = zeros(length(valueDiffs), 1);
    subjCountLeftFirst = zeros(length(valueDiffs), 1);
    subjCountRightFirst = zeros(length(valueDiffs), 1);

    for s=sessions
        [countTotal, countLeftFirst, countRightFirst] = ...
            ProbFixateItemFirstVsValueDiff(parcodes(i,:), s, valueDiffs);

        subjCountTotal = subjCountTotal + countTotal;
        subjCountLeftFirst = subjCountLeftFirst + countLeftFirst;
        subjCountRightFirst = subjCountRightFirst + countRightFirst;
    end

    aggregCountTotal = aggregCountTotal + subjCountTotal;
    aggregCountLeftFirst = aggregCountLeftFirst + subjCountLeftFirst;
    aggregCountRightFirst = aggregCountRightFirst + subjCountRightFirst;
end

% Plot aggregated curves.
aggregProbLeftFirst = aggregCountLeftFirst ./ aggregCountTotal;
stdProbLeftFirst = sqrt(aggregProbLeftFirst .* (1-aggregProbLeftFirst));
confIntProbLeftFirst = Get95PercConfidenceInterval( ...
    stdProbLeftFirst, aggregCountTotal);

aggregProbRightFirst = aggregCountRightFirst ./ aggregCountTotal;
stdProbRightFirst = sqrt(aggregProbRightFirst .* (1-aggregProbRightFirst));
confIntProbRightFirst = Get95PercConfidenceInterval( ...
    stdProbRightFirst, aggregCountTotal);

figure; hold all;
errorbar(valueDiffs, aggregProbLeftFirst, confIntProbLeftFirst, ...
    '--.', 'MarkerSize', 25, 'Color', cyan, 'LineWidth', 3);
errorbar(valueDiffs, aggregProbRightFirst, confIntProbRightFirst, ...
    '--.', 'MarkerSize', 25, 'Color', magenta, 'LineWidth', 3);
line(xLim,[0.5 0.5],'LineStyle','--','Color',[0.5 0.5 0.5]);
xlim(xLim);
xlabel('r_{left} - r_{right}','FontSize', 24);
ylabel('P(first fixation)','FontSize', 24);
legend('Left', 'Right');
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);



%% Plot probability of fixating item first as a function of left value and
% of right value.

aggregCountTotalValLeft = zeros(length(values), 1);
aggregCountLeftFirstValLeft = zeros(length(values), 1);
aggregCountRightFirstValLeft = zeros(length(values), 1);

aggregCountTotalValRight = zeros(length(values), 1);
aggregCountLeftFirstValRight = zeros(length(values), 1);
aggregCountRightFirstValRight = zeros(length(values), 1);

for i=1:length(parcodes)
    subjCountTotalValLeft = zeros(length(values), 1);
    subjCountLeftFirstValLeft = zeros(length(values), 1);
    subjCountRightFirstValLeft = zeros(length(values), 1);

    subjCountTotalValRight = zeros(length(values), 1);
    subjCountLeftFirstValRight = zeros(length(values), 1);
    subjCountRightFirstValRight = zeros(length(values), 1);

    for s=sessions
        [countTotalValLeft, countLeftFirstValLeft, ...
            countRightFirstValLeft, countTotalValRight, ...
            countLeftFirstValRight, countRightFirstValRight] = ...
            ProbFixateItemFirstVsItemValue(parcodes(i,:), s, values);
        
        subjCountTotalValLeft = subjCountTotalValLeft + countTotalValLeft;
        subjCountLeftFirstValLeft = subjCountLeftFirstValLeft + ...
            countLeftFirstValLeft;
        subjCountRightFirstValLeft = subjCountRightFirstValLeft + ...
            countRightFirstValLeft;

        subjCountTotalValRight = subjCountTotalValRight + ...
            countTotalValRight;
        subjCountLeftFirstValRight = subjCountLeftFirstValRight + ...
            countLeftFirstValRight;
        subjCountRightFirstValRight = subjCountRightFirstValRight + ...
            countRightFirstValRight;
    end

    aggregCountTotalValLeft = aggregCountTotalValLeft + ...
        subjCountTotalValLeft;
    aggregCountLeftFirstValLeft = aggregCountLeftFirstValLeft + ...
        subjCountLeftFirstValLeft;
    aggregCountRightFirstValLeft = aggregCountRightFirstValLeft + ...
        subjCountRightFirstValLeft;
    
    aggregCountTotalValRight = aggregCountTotalValRight + ...
        subjCountTotalValRight;
    aggregCountLeftFirstValRight = aggregCountLeftFirstValRight + ...
        subjCountLeftFirstValRight;
    aggregCountRightFirstValRight = aggregCountRightFirstValRight + ...
        subjCountRightFirstValRight;
end

% Plot aggregated curves for value left.
aggregProbLeftFirstValLeft = aggregCountLeftFirstValLeft ./ ...
    aggregCountTotalValLeft;
stdProbLeftFirstValLeft = sqrt(aggregProbLeftFirstValLeft .* ...
    (1-aggregProbLeftFirstValLeft));
confIntProbLeftFirstValLeft = Get95PercConfidenceInterval( ...
    stdProbLeftFirstValLeft, aggregCountTotalValLeft);

aggregProbRightFirstValLeft = aggregCountRightFirstValLeft ./ ...
    aggregCountTotalValLeft;
stdProbRightFirstValLeft = sqrt(aggregProbRightFirstValLeft .* ...
    (1-aggregProbRightFirstValLeft));
confIntProbRightFirstValLeft = Get95PercConfidenceInterval( ...
    stdProbRightFirstValLeft, aggregCountTotalValLeft);

figure; hold all;
errorbar(values, aggregProbLeftFirstValLeft, ...
    confIntProbLeftFirstValLeft, '--.', 'MarkerSize', 25, 'Color', ...
    cyan, 'LineWidth', 3);
errorbar(values, aggregProbRightFirstValLeft, ...
    confIntProbRightFirstValLeft, '--.', 'MarkerSize', 25, 'Color', ...
    magenta, 'LineWidth', 3);
line([-0.5 3.5],[0.5 0.5],'LineStyle','--','Color',[0.5 0.5 0.5]);
xlim([-0.5 3.5]);
ylim([0 1]);
xlabel('r_{left}','FontSize', 24);
ylabel('P(first fixation)','FontSize', 24);
legend('Left', 'Right');
set(gca,'FontSize',20);

orient landscape
print('-dpsc2', '-append', plotsFileName);

% Plot aggregated curves for value right.
aggregProbLeftFirstValRight = aggregCountLeftFirstValRight ./ ...
    aggregCountTotalValRight;
stdProbLeftFirstValRight = sqrt(aggregProbLeftFirstValRight .* ...
    (1-aggregProbLeftFirstValRight));
confIntProbLeftFirstValRight = Get95PercConfidenceInterval( ...
    stdProbLeftFirstValRight, aggregCountTotalValRight);

aggregProbRightFirstValRight = aggregCountRightFirstValRight ./ ...
    aggregCountTotalValRight;
stdProbRightFirstValRight = sqrt(aggregProbRightFirstValRight .* ...
    (1-aggregProbRightFirstValRight));
confIntProbRightFirstValRight = Get95PercConfidenceInterval( ...
    stdProbRightFirstValRight, aggregCountTotalValRight);

figure; hold all;
errorbar(values, aggregProbLeftFirstValRight, ...
    confIntProbLeftFirstValRight, '--.', 'MarkerSize', 25, 'Color', ...
    cyan, 'LineWidth', 3);
errorbar(values, aggregProbRightFirstValRight, ...
    confIntProbRightFirstValRight, '--.', 'MarkerSize', 25, 'Color', ...
    magenta, 'LineWidth', 3);
line([-0.5 3.5],[0.5 0.5],'LineStyle','--','Color',[0.5 0.5 0.5]);
xlim([-0.5 3.5]);
ylim([0 1]);
xlabel('r_{right}','FontSize', 24);
ylabel('P(first fixation)','FontSize', 24);
legend('Left', 'Right');
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% Plot duration of first, middle and last fixations as a function of value
% difference between fixated and non-fixated items.

allFirstFixTime = cell(length(valueDiffs), 1);
allLastFixTime = cell(length(valueDiffs), 1);
allMiddleFixTime = cell(length(valueDiffs), 1);

for i=1:length(parcodes)
    for s=sessions
        [firstFixTimes, secondFixTimes, otherFixTimes, lastFixTimes] = ...
            FixationDurationVsValueFixMinusUnfix(valueDiffs, [], [], ...
            [], [], parcodes(i,:), s);

        for j=1:length(valueDiffs)
            allFirstFixTime{j} = [allFirstFixTime{j}; firstFixTimes{j}];
            allLastFixTime{j} = [allLastFixTime{j}; lastFixTimes{j}];
            allMiddleFixTime{j} = [allMiddleFixTime{j}; ...
                secondFixTimes{j}; otherFixTimes{j}];
        end
    end
end

meanFirstFixTime = zeros(length(valueDiffs), 1);
confIntFirstFixTime = zeros(length(valueDiffs), 1);

meanLastFixTime = zeros(length(valueDiffs), 1);
confIntLastFixTime = zeros(length(valueDiffs), 1);

meanMiddleFixTime = zeros(length(valueDiffs), 1);
confIntMiddleFixTime = zeros(length(valueDiffs), 1);

for i=1:length(valueDiffs)
    meanFirstFixTime(i) = mean(allFirstFixTime{i});
    confIntFirstFixTime(i) = Get95PercConfidenceInterval( ...
        std(allFirstFixTime{i}), length(allFirstFixTime{i}));
    
    meanLastFixTime(i) = mean(allLastFixTime{i});
    confIntLastFixTime(i) = Get95PercConfidenceInterval( ...
        std(allLastFixTime{i}), length(allLastFixTime{i}));
    
    meanMiddleFixTime(i) = mean(allMiddleFixTime{i});
    confIntMiddleFixTime(i) = Get95PercConfidenceInterval( ...
        std(allMiddleFixTime{i}), length(allMiddleFixTime{i}));
end

figure; hold all;
errorbar(valueDiffs, meanFirstFixTime, confIntFirstFixTime, '--.', ...
    'MarkerSize', 25, 'Color', cyan, 'LineWidth', 3);
errorbar(valueDiffs, meanLastFixTime, confIntLastFixTime, '--.', ...
    'MarkerSize', 25, 'Color', pink, 'LineWidth', 3);
errorbar(valueDiffs, meanMiddleFixTime, confIntMiddleFixTime, '--.', ...
    'MarkerSize', 25, 'Color', yellow, 'LineWidth', 3);
xlim(xLim);
xlabel('r_{fixated} - r_{non-fixated}','FontSize', 24);
ylabel('Fixation duration [ms]','FontSize', 24);
legend('First', 'Last', 'Middle', 'Location', 'NorthWest');
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% Plot duration of first, middle and last fixations as a function of value
% of fixated item and value of non-fixated item.

allFirstFixTimeValFix = cell(length(values), 1);
allFirstFixTimeValNonFix = cell(length(values), 1);

allLastFixTimeValFix = cell(length(values), 1);
allLastFixTimeValNonFix = cell(length(values), 1);

allMiddleFixTimeValFix = cell(length(values), 1);
allMiddleFixTimeValNonFix = cell(length(values), 1);

for i=1:length(parcodes)
    for s=sessions
        [firstFixTimeValFix, firstFixTimeValNonFix, ...
            lastFixTimeValFix, lastFixTimeValNonFix, ...
            middleFixTimeValFix, middleFixTimeValNonFix] = ...
            FixationDurationVsItemValue(parcodes(i,:), s, values);

        for j=1:length(values)
            allFirstFixTimeValFix{j} = [allFirstFixTimeValFix{j}; ...
                firstFixTimeValFix{j}];
            allFirstFixTimeValNonFix{j} = [allFirstFixTimeValNonFix{j}; ...
                firstFixTimeValNonFix{j}];

            allLastFixTimeValFix{j} = [allLastFixTimeValFix{j}; ...
                lastFixTimeValFix{j}];
            allLastFixTimeValNonFix{j} = [allLastFixTimeValNonFix{j}; ...
                lastFixTimeValNonFix{j}];

            allMiddleFixTimeValFix{j} = [allMiddleFixTimeValFix{j}; ...
                middleFixTimeValFix{j}];
            allMiddleFixTimeValNonFix{j} = ...
                [allMiddleFixTimeValNonFix{j}; middleFixTimeValNonFix{j}];
        end
    end
end

meanFirstFixTimeValFix = zeros(length(values), 1);
confIntFirstFixTimeValFix = zeros(length(values), 1);
meanFirstFixTimeValNonFix = zeros(length(values), 1);
confIntFirstFixTimeValNonFix = zeros(length(values), 1);

meanLastFixTimeValFix = zeros(length(values), 1);
confIntLastFixTimeValFix = zeros(length(values), 1);
meanLastFixTimeValNonFix = zeros(length(values), 1);
confIntLastFixTimeValNonFix = zeros(length(values), 1);

meanMiddleFixTimeValFix = zeros(length(values), 1);
confIntMiddleFixTimeValFix = zeros(length(values), 1);
meanMiddleFixTimeValNonFix = zeros(length(values), 1);
confIntMiddleFixTimeValNonFix = zeros(length(values), 1);

for i=1:length(values)
    meanFirstFixTimeValFix(i) = mean(allFirstFixTimeValFix{i});
    confIntFirstFixTimeValFix(i) = Get95PercConfidenceInterval( ...
        std(allFirstFixTimeValFix{i}), length(allFirstFixTimeValFix{i}));
    meanFirstFixTimeValNonFix(i) = mean(allFirstFixTimeValNonFix{i});
    confIntFirstFixTimeValNonFix(i) = Get95PercConfidenceInterval( ...
        std(allFirstFixTimeValNonFix{i}), ...
        length(allFirstFixTimeValNonFix{i}));
    
    meanLastFixTimeValFix(i) = mean(allLastFixTimeValFix{i});
    confIntLastFixTimeValFix(i) = Get95PercConfidenceInterval( ...
        std(allLastFixTimeValFix{i}), length(allLastFixTimeValFix{i}));
    meanLastFixTimeValNonFix(i) = mean(allLastFixTimeValNonFix{i});
    confIntLastFixTimeValNonFix(i) = Get95PercConfidenceInterval( ...
        std(allLastFixTimeValNonFix{i}), ...
        length(allLastFixTimeValNonFix{i}));
    
    meanMiddleFixTimeValFix(i) = mean(allMiddleFixTimeValFix{i});
    confIntMiddleFixTimeValFix(i) = Get95PercConfidenceInterval( ...
        std(allMiddleFixTimeValFix{i}), length(allMiddleFixTimeValFix{i}));
    meanMiddleFixTimeValNonFix(i) = mean(allMiddleFixTimeValNonFix{i});
    confIntMiddleFixTimeValNonFix(i) = Get95PercConfidenceInterval( ...
        std(allMiddleFixTimeValNonFix{i}), ...
        length(allMiddleFixTimeValNonFix{i}));
end

% Plot as function of value of fixated item.
figure; hold all;
errorbar(values, meanFirstFixTimeValFix, confIntFirstFixTimeValFix, ...
    '--.', 'MarkerSize', 25, 'Color', cyan, 'LineWidth', 3);
errorbar(values, meanLastFixTimeValFix, confIntLastFixTimeValFix, ...
    '--.', 'MarkerSize', 25, 'Color', pink, 'LineWidth', 3);
errorbar(values, meanMiddleFixTimeValFix, ...
    confIntMiddleFixTimeValFix, '--.', 'MarkerSize', 25, 'Color', ...
    yellow, 'LineWidth', 3);
xlim([-0.5 3.5]);
xlabel('r_{fixated}','FontSize', 24);
ylabel('Fixation duration [ms]','FontSize', 24);
legend('First', 'Last', 'Middle', 'Location', 'NorthWest');
set(gca,'FontSize',20);

orient landscape
print('-dpsc2', '-append', plotsFileName);

% Plot as function of value of non-fixated item.
figure; hold all;
errorbar(values, meanFirstFixTimeValNonFix, ...
    confIntFirstFixTimeValNonFix, '--.', 'MarkerSize', 25, 'Color', ...
    cyan, 'LineWidth', 3);
errorbar(values, meanLastFixTimeValNonFix, ...
    confIntLastFixTimeValNonFix, '--.', 'MarkerSize', 25, 'Color', ...
    pink, 'LineWidth', 3);
errorbar(values, meanMiddleFixTimeValNonFix, ...
    confIntMiddleFixTimeValNonFix, '--.', 'MarkerSize', 25, 'Color', ...
    yellow, 'LineWidth', 3);
xlim([-0.5 3.5]);
xlabel('r_{non-fixated}','FontSize', 24);
ylabel('Fixation duration [ms]','FontSize', 24);
legend('First', 'Last', 'Middle', 'Location', 'NorthEast');
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% Plot duration of first, middle and last fixations as a function of value
% difference between left and right items.

allFirstFixTime = cell(length(valueDiffs), 1);
allLastFixTime = cell(length(valueDiffs), 1);
allMiddleFixTime = cell(length(valueDiffs), 1);

for i=1:length(parcodes)
    for s=sessions
        [firstFixTimes, secondFixTimes, otherFixTimes, lastFixTimes] = ...
            FixationDurationVsValueDiff(valueDiffs, [], [], [], [], ...
            parcodes(i,:), s);

        for j=1:length(valueDiffs)
            allFirstFixTime{j} = [allFirstFixTime{j}; firstFixTimes{j}];
            allLastFixTime{j} = [allLastFixTime{j}; lastFixTimes{j}];
            allMiddleFixTime{j} = [allMiddleFixTime{j}; ...
                secondFixTimes{j}; otherFixTimes{j}];
        end
    end
end

meanFirstFixTime = zeros(length(valueDiffs), 1);
confIntFirstFixTime = zeros(length(valueDiffs), 1);

meanLastFixTime = zeros(length(valueDiffs), 1);
confIntLastFixTime = zeros(length(valueDiffs), 1);

meanMiddleFixTime = zeros(length(valueDiffs), 1);
confIntMiddleFixTime = zeros(length(valueDiffs), 1);

for i=1:length(valueDiffs)
    meanFirstFixTime(i) = mean(allFirstFixTime{i});
    confIntFirstFixTime(i) = Get95PercConfidenceInterval( ...
        std(allFirstFixTime{i}), length(allFirstFixTime{i}));
    
    meanLastFixTime(i) = mean(allLastFixTime{i});
    confIntLastFixTime(i) = Get95PercConfidenceInterval( ...
        std(allLastFixTime{i}), length(allLastFixTime{i}));
    
    meanMiddleFixTime(i) = mean(allMiddleFixTime{i});
    confIntMiddleFixTime(i) = Get95PercConfidenceInterval( ...
        std(allMiddleFixTime{i}), length(allMiddleFixTime{i}));
end

figure; hold all;
errorbar(valueDiffs, meanFirstFixTime, confIntFirstFixTime, '--.', ...
    'MarkerSize', 25, 'Color', cyan, 'LineWidth', 3);
errorbar(valueDiffs, meanLastFixTime, confIntLastFixTime, '--.', ...
    'MarkerSize', 25, 'Color', pink, 'LineWidth', 3);
errorbar(valueDiffs, meanMiddleFixTime, confIntMiddleFixTime, ...
    '--.', 'MarkerSize', 25, 'Color', yellow, 'LineWidth', 3);
xlim(xLim);
xlabel('r_{left} - r_{right}','FontSize', 24);
ylabel('Fixation duration [ms]','FontSize', 24);
legend('First', 'Last', 'Middle', 'Location', 'NorthEast');
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% Plot duration of first, middle and last fixations as a function of value
% left and value right.

allFirstFixTimeValLeft = cell(length(values), 1);
allFirstFixTimeValRight = cell(length(values), 1);

allLastFixTimeValLeft = cell(length(values), 1);
allLastFixTimeValRight = cell(length(values), 1);

allMiddleFixTimeValLeft = cell(length(values), 1);
allMiddleFixTimeValRight = cell(length(values), 1);

for i=1:length(parcodes)
    for s=sessions
        [firstFixTimeValLeft, firstFixTimeValRight, ...
            lastFixTimeValLeft, lastFixTimeValRight, ...
            middleFixTimeValLeft, middleFixTimeValRight] = ...
            FixationDurationVsLeftRight(parcodes(i,:), s, values);

        for j=1:length(values)
            allFirstFixTimeValLeft{j} = [allFirstFixTimeValLeft{j}; ...
                firstFixTimeValLeft{j}];
            allFirstFixTimeValRight{j} = [allFirstFixTimeValRight{j}; ...
                firstFixTimeValRight{j}];

            allLastFixTimeValLeft{j} = [allLastFixTimeValLeft{j}; ...
                lastFixTimeValLeft{j}];
            allLastFixTimeValRight{j} = [allLastFixTimeValRight{j}; ...
                lastFixTimeValRight{j}];

            allMiddleFixTimeValLeft{j} = [allMiddleFixTimeValLeft{j}; ...
                middleFixTimeValLeft{j}];
            allMiddleFixTimeValRight{j} = ...
                [allMiddleFixTimeValRight{j}; middleFixTimeValRight{j}];
        end
    end
end

meanFirstFixTimeValLeft = zeros(length(values), 1);
confIntFirstFixTimeValLeft = zeros(length(values), 1);
meanFirstFixTimeValRight = zeros(length(values), 1);
confIntFirstFixTimeValRight = zeros(length(values), 1);

meanLastFixTimeValLeft = zeros(length(values), 1);
confIntLastFixTimeValLeft = zeros(length(values), 1);
meanLastFixTimeValRight = zeros(length(values), 1);
confIntLastFixTimeValRight = zeros(length(values), 1);

meanMiddleFixTimeValLeft = zeros(length(values), 1);
confIntMiddleFixTimeValLeft = zeros(length(values), 1);
meanMiddleFixTimeValRight = zeros(length(values), 1);
confIntMiddleFixTimeValRight = zeros(length(values), 1);

for i=1:length(values)
    meanFirstFixTimeValLeft(i) = mean(allFirstFixTimeValLeft{i});
    confIntFirstFixTimeValLeft(i) = Get95PercConfidenceInterval( ...
        std(allFirstFixTimeValLeft{i}), length(allFirstFixTimeValLeft{i}));
    meanFirstFixTimeValRight(i) = mean(allFirstFixTimeValRight{i});
    confIntFirstFixTimeValRight(i) = Get95PercConfidenceInterval( ...
        std(allFirstFixTimeValRight{i}), ...
        length(allFirstFixTimeValRight{i}));
    
    meanLastFixTimeValLeft(i) = mean(allLastFixTimeValLeft{i});
    confIntLastFixTimeValLeft(i) = Get95PercConfidenceInterval( ...
        std(allLastFixTimeValLeft{i}), length(allLastFixTimeValLeft{i}));
    meanLastFixTimeValRight(i) = mean(allLastFixTimeValRight{i});
    confIntLastFixTimeValRight(i) = Get95PercConfidenceInterval( ...
        std(allLastFixTimeValRight{i}), ...
        length(allLastFixTimeValRight{i}));
    
    meanMiddleFixTimeValLeft(i) = mean(allMiddleFixTimeValLeft{i});
    confIntMiddleFixTimeValLeft(i) = Get95PercConfidenceInterval( ...
        std(allMiddleFixTimeValLeft{i}), ...
        length(allMiddleFixTimeValLeft{i}));
    meanMiddleFixTimeValRight(i) = mean(allMiddleFixTimeValRight{i});
    confIntMiddleFixTimeValRight(i) = Get95PercConfidenceInterval( ...
        std(allMiddleFixTimeValRight{i}), ...
        length(allMiddleFixTimeValRight{i}));
end

% Plot as function of value of left item.
figure; hold all;
errorbar(values, meanFirstFixTimeValLeft, ...
    confIntFirstFixTimeValLeft, '--.', 'MarkerSize', 25, 'Color', ...
    cyan, 'LineWidth', 3);
errorbar(values, meanLastFixTimeValLeft, confIntLastFixTimeValLeft, ...
    '--.', 'MarkerSize', 25, 'Color', pink, 'LineWidth', 3);
errorbar(values, meanMiddleFixTimeValLeft, ...
    confIntMiddleFixTimeValLeft, '--.', 'MarkerSize', 25, 'Color', ...
    yellow, 'LineWidth', 3);
xlim([-0.5 3.5]);
xlabel('r_{left}','FontSize', 24);
ylabel('Fixation duration [ms]','FontSize', 24);
legend('First', 'Last', 'Middle', 'Location', 'NorthEast');
set(gca,'FontSize',20);

orient landscape
print('-dpsc2', '-append', plotsFileName);

% Plot as function of value of right item.
figure; hold all;
errorbar(values, meanFirstFixTimeValRight, ...
    confIntFirstFixTimeValRight, '--.', 'MarkerSize', 25, 'Color', ...
    cyan, 'LineWidth', 3);
errorbar(values, meanLastFixTimeValRight, ...
    confIntLastFixTimeValRight, '--.', 'MarkerSize', 25, 'Color', ...
    pink, 'LineWidth', 3);
errorbar(values, meanMiddleFixTimeValRight, ...
    confIntMiddleFixTimeValRight, '--.', 'MarkerSize', 25, 'Color', ...
    yellow, 'LineWidth', 3);
xlim([-0.5 3.5]);
xlabel('r_{right}','FontSize', 24);
ylabel('Fixation duration [ms]','FontSize', 24);
legend('First', 'Last', 'Middle', 'Location', 'NorthWest');
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% First fixation probability vs. best - worst.

aggregCountTotal = zeros(length(positiveplotValueDiffs), 1);
aggregCountBestFirst = zeros(length(positiveplotValueDiffs), 1);

for i=1:length(parcodes)
    subjCountTotal = zeros(length(positiveplotValueDiffs), 1);
    subjCountBestFirst = zeros(length(positiveplotValueDiffs), 1);

    for s=sessions
        [countTotal, countBestFirst] = ...
            ProbFixateBestItemFirstVsBestMinusWorst(parcodes(i,:), s, ...
            positiveplotValueDiffs);

        subjCountTotal = subjCountTotal + countTotal;
        subjCountBestFirst = subjCountBestFirst + countBestFirst;
    end

    aggregCountTotal = aggregCountTotal + subjCountTotal;
    aggregCountBestFirst = aggregCountBestFirst + subjCountBestFirst;
end

% Plot aggregated curves.
aggregProbBestFirst = aggregCountBestFirst ./ aggregCountTotal;
stdProbBestFirst = sqrt(aggregProbBestFirst .* (1-aggregProbBestFirst));
confIntProbLeftFirst = Get95PercConfidenceInterval( ...
    stdProbBestFirst, aggregCountTotal);

figure; hold on;
bar(positiveplotValueDiffs, aggregProbBestFirst, 'FaceColor', ...
    0.8 + 0.2 * cyan, 'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, ...
    'LineWidth', 3);
errorbar(positiveplotValueDiffs, aggregProbBestFirst, ...
    confIntProbLeftFirst, '.', 'Color', 0.7 * cyan, 'LineWidth', 3);
xlim([0.5 3.5]);
set(gca, 'XTick', positiveplotValueDiffs, 'XTickLabel', ...
    positiveplotValueDiffs);
ylabel('P(first fixation to closest)','FontSize', 24);
xlabel('r_{closest} - r_{farthest}','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);



%% Middle fixation duration vs. fixated item value - non-fixated item
% value.

allMiddleFixTime = cell(length(valueDiffs), 1);

for i=1:length(parcodes)
    for s=sessions
        [~, secondFixTime, otherMiddleFixTime, ~] = ...
            FixationDurationVsValueFixMinusUnfix(valueDiffs, [], [], ...
            [], [], parcodes(i,:), s);

        for j=1:length(valueDiffs)
            allMiddleFixTime{j} = [allMiddleFixTime{j}; ...
                secondFixTime{j}; otherMiddleFixTime{j}];
        end
    end
end

meanMiddleFixTime = zeros(length(valueDiffs), 1);
confIntMiddleFixTime = zeros(length(valueDiffs), 1);
for i=1:length(valueDiffs)
    meanMiddleFixTime(i) = mean(allMiddleFixTime{i});
    confIntMiddleFixTime(i) = Get95PercConfidenceInterval( ...
        std(allMiddleFixTime{i}), length(allMiddleFixTime{i}));
end

figure; hold on;
bar(valueDiffs, meanMiddleFixTime, 'FaceColor', 0.8 + 0.2 * cyan, ...
    'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, 'LineWidth', 3);
errorbar(valueDiffs, meanMiddleFixTime, confIntMiddleFixTime, '.', ...
    'Color', 0.7 * cyan, 'LineWidth', 3);
xlim(xLim);
set(gca, 'XTick', valueDiffs, 'XTickLabel', valueDiffs);
xlabel('r_{fixated} - r_{unfixated}','FontSize', 24);
ylabel('Middle fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);

% Equal number of fixations for the symmetric numbers.
num1 = min(length(allMiddleFixTime{1}), length(allMiddleFixTime{7}));
idx1 = randperm(num1,num1);
num2 = min(length(allMiddleFixTime{2}), length(allMiddleFixTime{6}));
idx2 = randperm(num2,num2);
num3 = min(length(allMiddleFixTime{3}), length(allMiddleFixTime{5}));
idx3 = randperm(num3,num3);
middleFix = cell(length(valueDiffs), 1);
middleFix{1} = allMiddleFixTime{1}(idx1);
middleFix{2} = allMiddleFixTime{2}(idx2);
middleFix{3} = allMiddleFixTime{3}(idx3);
middleFix{4} = allMiddleFixTime{4};
middleFix{5} = allMiddleFixTime{5}(idx3);
middleFix{6} = allMiddleFixTime{6}(idx2);
middleFix{7} = allMiddleFixTime{7}(idx1);

meanMiddleFixTime = zeros(length(valueDiffs), 1);
confIntMiddleFixTime = zeros(length(valueDiffs), 1);
for i=1:length(valueDiffs)
    meanMiddleFixTime(i) = mean(middleFix{i});
    confIntMiddleFixTime(i) = Get95PercConfidenceInterval( ...
        std(middleFix{i}), length(middleFix{i}));
end

figure; hold on;
bar(valueDiffs, meanMiddleFixTime, 'FaceColor', 0.8 + 0.2 * cyan, ...
    'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, 'LineWidth', 3);
errorbar(valueDiffs, meanMiddleFixTime, confIntMiddleFixTime, ...
    '.', 'Color', 0.7 * cyan, 'LineWidth', 3);
xlim(xLim);
set(gca, 'XTick', valueDiffs, 'XTickLabel', valueDiffs);
title('Balanced number of fixations','FontSize', 24);
xlabel('r_{fixated} - r_{unfixated}','FontSize', 24);
ylabel('Middle fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);

% Fold the plot in half.
val = 0:1:3;
middleFix = cell(length(val), 1);
middleFix{1} = allMiddleFixTime{4};
middleFix{2} = [allMiddleFixTime{3}; allMiddleFixTime{5}];
middleFix{3} = [allMiddleFixTime{2}; allMiddleFixTime{6}];
middleFix{4} = [allMiddleFixTime{1}; allMiddleFixTime{7}];

meanMiddleFixTime = zeros(length(val), 1);
confIntMiddleFixTime = zeros(length(val), 1);
for i=1:length(val)
    meanMiddleFixTime(i) = mean(middleFix{i});
    confIntMiddleFixTime(i) = Get95PercConfidenceInterval( ...
        std(middleFix{i}), length(middleFix{i}));
end

figure; hold on;
bar(val, meanMiddleFixTime, 'FaceColor', 0.8 + 0.2 * cyan, ...
    'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, 'LineWidth', 3);
errorbar(val, meanMiddleFixTime, confIntMiddleFixTime, '.', ...
    'Color', 0.7 * cyan, 'LineWidth', 3);
xlim([-0.5 3.5]);
set(gca, 'XTick', val, 'XTickLabel', val);
title('Folded in half','FontSize', 24);
xlabel('r_{fixated} - r_{unfixated}','FontSize', 24);
ylabel('Middle fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% Middle fixation duration vs. fixated item value.

allMiddleFixTimeValFix = cell(length(values), 1);

for i=1:length(parcodes)
    for s=sessions
        [~, ~, ~, ~, middleFixTimeValFix, ~] = ...
            FixationDurationVsItemValue(parcodes(i,:), s, values);

        for j=1:length(values)
            allMiddleFixTimeValFix{j} = [allMiddleFixTimeValFix{j}; ...
                middleFixTimeValFix{j}];
        end
    end
end

meanMiddleFixTimeValFix = zeros(length(values), 1);
confIntMiddleFixTimeValFix = zeros(length(values), 1);

for i=1:length(values)
    meanMiddleFixTimeValFix(i) = mean(allMiddleFixTimeValFix{i});
    confIntMiddleFixTimeValFix(i) = Get95PercConfidenceInterval( ...
        std(allMiddleFixTimeValFix{i}), length(allMiddleFixTimeValFix{i}));
end

% Plot as function of value of fixated item.
figure; hold on;
bar(values, meanMiddleFixTimeValFix, 'FaceColor', ...
    0.8 + 0.2 * cyan, 'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, ...
    'LineWidth', 3);
errorbar(values, meanMiddleFixTimeValFix, ...
    confIntMiddleFixTimeValFix, '.', 'Color', 0.7 * cyan, 'LineWidth', 3);
xlim([-0.5 3.5]);
set(gca, 'XTick', values, 'XTickLabel', values);
xlabel('r_{fixated}','FontSize', 24);
ylabel('Middle fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% Middle fixation duration vs. unfixated item value.

allMiddleFixTimeValUnfix = cell(length(values), 1);

for i=1:length(parcodes)
    for s=sessions
        [~, ~, ~, ~, ~, middleFixTimeValUnfix] = ...
            FixationDurationVsItemValue(parcodes(i,:), s, values);

        for j=1:length(values)
            allMiddleFixTimeValUnfix{j} = [allMiddleFixTimeValUnfix{j}; ...
                middleFixTimeValUnfix{j}];
        end
    end
end

meanMiddleFixTimeValUnfix = zeros(length(values), 1);
confIntMiddleFixTimeValUnfix = zeros(length(values), 1);

for i=1:length(values)
    meanMiddleFixTimeValUnfix(i) = mean(allMiddleFixTimeValUnfix{i});
    confIntMiddleFixTimeValUnfix(i) = Get95PercConfidenceInterval( ...
        std(allMiddleFixTimeValUnfix{i}), ...
        length(allMiddleFixTimeValUnfix{i}));
end

% Plot as function of value of the unfixated item.
figure; hold on;
bar(values, meanMiddleFixTimeValUnfix, 'FaceColor', ...
    0.8 + 0.2 * cyan, 'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, ...
    'LineWidth', 3);
errorbar(values, meanMiddleFixTimeValUnfix, ...
    confIntMiddleFixTimeValUnfix, '.', 'Color', 0.7 * cyan, ...
    'LineWidth', 3);
xlim([-0.5 3.5]);
set(gca, 'XTick', values, 'XTickLabel', values);
xlabel('r_{unfixated}','FontSize', 24);
ylabel('Middle fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% Middle fixation duration vs. best value - worst value.

allMiddleFixTime = cell(length(nonNegativeplotValueDiffs), 1);

for i=1:length(parcodes)
    for s=sessions
        [~, secondFixTime, otherMiddleFixTime, ~] = ...
            FixationDurationVsValueBestMinusWorst( ...
            nonNegativeplotValueDiffs, [], [], [], [], parcodes(i,:), s);

        for j=1:length(nonNegativeplotValueDiffs)
            allMiddleFixTime{j} = [allMiddleFixTime{j}; ...
                secondFixTime{j}; otherMiddleFixTime{j}];
        end
    end
end

meanMiddleFixTime = zeros(length(nonNegativeplotValueDiffs), 1);
confIntMiddleFixTime = zeros(length(nonNegativeplotValueDiffs), 1);

for i=1:length(nonNegativeplotValueDiffs)
    meanMiddleFixTime(i) = mean(allMiddleFixTime{i});
    confIntMiddleFixTime(i) = Get95PercConfidenceInterval( ...
        std(allMiddleFixTime{i}), length(allMiddleFixTime{i}));
end

figure; hold on;
bar(nonNegativeplotValueDiffs, meanMiddleFixTime, 'FaceColor', ...
    0.8 + 0.2 * cyan, 'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, ...
    'LineWidth', 3);
errorbar(nonNegativeplotValueDiffs, meanMiddleFixTime, ...
    confIntMiddleFixTime, '.', 'Color', 0.7 * cyan, 'LineWidth', 3);
xlim([-0.5 3.5]);
set(gca, 'XTick', nonNegativeplotValueDiffs, 'XTickLabel', ...
    nonNegativeplotValueDiffs);
xlabel('r_{closest} - r_{farthest}','FontSize', 24);
ylabel('Middle fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% First fixation duration vs. fixated item value - non-fixated item
% value.

allFirstFixTime = cell(length(valueDiffs), 1);

for i=1:length(parcodes)
    for s=sessions
        [firstFixTime, ~, ~, ~] = FixationDurationVsValueFixMinusUnfix( ...
            valueDiffs, [], [], [], [], parcodes(i,:), s);

        for j=1:length(valueDiffs)
            allFirstFixTime{j} = [allFirstFixTime{j}; firstFixTime{j}];
        end
    end
end

meanFirstFixTime = zeros(length(valueDiffs), 1);
confIntFirstFixTime = zeros(length(valueDiffs), 1);
for i=1:length(valueDiffs)
    meanFirstFixTime(i) = mean(allFirstFixTime{i});
    confIntFirstFixTime(i) = Get95PercConfidenceInterval( ...
        std(allFirstFixTime{i}), length(allFirstFixTime{i}));
end

figure; hold on;
bar(valueDiffs, meanFirstFixTime, 'FaceColor', 0.8 + 0.2 * cyan, ...
    'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, 'LineWidth', 3);
errorbar(valueDiffs, meanFirstFixTime, confIntFirstFixTime, ...
    '.', 'Color', 0.7 * cyan, 'LineWidth', 3);
xlim(xLim);
set(gca, 'XTick', valueDiffs, 'XTickLabel', valueDiffs);
xlabel('r_{fixated} - r_{unfixated}','FontSize', 24);
ylabel('First fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% First fixation duration vs. fixated item value.

allFirstFixTimeValFix = cell(length(values), 1);

for i=1:length(parcodes)
    for s=sessions
        [firstFixTimeValFix, ~, ~, ~, ~, ~] = ...
            FixationDurationVsItemValue(parcodes(i,:), s, values);

        for j=1:length(values)
            allFirstFixTimeValFix{j} = [allFirstFixTimeValFix{j}; ...
                firstFixTimeValFix{j}];
        end
    end
end

meanFirstFixTimeValFix = zeros(length(values), 1);
confIntFirstFixTimeValFix = zeros(length(values), 1);

for i=1:length(values)
    meanFirstFixTimeValFix(i) = mean(allFirstFixTimeValFix{i});
    confIntFirstFixTimeValFix(i) = Get95PercConfidenceInterval( ...
        std(allFirstFixTimeValFix{i}), length(allFirstFixTimeValFix{i}));
end

% Plot as function of value of fixated item.
figure; hold on;
bar(values, meanFirstFixTimeValFix, 'FaceColor', ...
    0.8 + 0.2 * cyan, 'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, ...
    'LineWidth', 3);
errorbar(values, meanFirstFixTimeValFix, ...
    confIntFirstFixTimeValFix, '.', 'Color', 0.7 * cyan, 'LineWidth', 3);
xlim([-0.5 3.5]);
set(gca, 'XTick', values, 'XTickLabel', values);
xlabel('r_{fixated}','FontSize', 24);
ylabel('First fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% First fixation duration vs. unfixated item value.

allFirstFixTimeValUnfix = cell(length(values), 1);

for i=1:length(parcodes)
    for s=sessions
        [~, firstFixTimeValUnfix, ~, ~, ~, ~] = ...
            FixationDurationVsItemValue(parcodes(i,:), s, values);

        for j=1:length(values)
            allFirstFixTimeValUnfix{j} = [allFirstFixTimeValUnfix{j}; ...
                firstFixTimeValUnfix{j}];
        end
    end
end

meanFirstFixTimeValUnfix = zeros(length(values), 1);
confIntFirstFixTimeValUnfix = zeros(length(values), 1);

for i=1:length(values)
    meanFirstFixTimeValUnfix(i) = mean(allFirstFixTimeValUnfix{i});
    confIntFirstFixTimeValUnfix(i) = Get95PercConfidenceInterval( ...
        std(allFirstFixTimeValUnfix{i}), ...
        length(allFirstFixTimeValUnfix{i}));
end

% Plot as function of value of the unfixated item.
figure; hold on;
bar(values, meanFirstFixTimeValUnfix, 'FaceColor', ...
    0.8 + 0.2 * cyan, 'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, ...
    'LineWidth', 3);
errorbar(values, meanFirstFixTimeValUnfix, ...
    confIntFirstFixTimeValUnfix, '.', 'Color', 0.7 * cyan, 'LineWidth', 3);
xlim([-0.5 3.5]);
set(gca, 'XTick', values, 'XTickLabel', values);
xlabel('r_{unfixated}','FontSize', 24);
ylabel('First fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% First fixation duration vs. best value - worst value.

allFirstFixTime = cell(length(nonNegativeplotValueDiffs), 1);

for i=1:length(parcodes)
    for s=sessions
        [firstFixTime, ~, ~, ~] = ...
            FixationDurationVsValueBestMinusWorst( ...
            nonNegativeplotValueDiffs, [], [], [], [], parcodes(i,:), s);

        for j=1:length(nonNegativeplotValueDiffs)
            allFirstFixTime{j} = [allFirstFixTime{j}; firstFixTime{j}];
        end
    end
end

meanFirstFixTime = zeros(length(nonNegativeplotValueDiffs), 1);
confIntFirstFixTime = zeros(length(nonNegativeplotValueDiffs), 1);

for i=1:length(nonNegativeplotValueDiffs)
    meanFirstFixTime(i) = mean(allFirstFixTime{i});
    confIntFirstFixTime(i) = Get95PercConfidenceInterval( ...
        std(allFirstFixTime{i}), length(allFirstFixTime{i}));
end

figure; hold on;
bar(nonNegativeplotValueDiffs, meanFirstFixTime, 'FaceColor', ...
    0.8 + 0.2 * cyan, 'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, ...
    'LineWidth', 3);
errorbar(nonNegativeplotValueDiffs, meanFirstFixTime, ...
    confIntFirstFixTime, '.', 'Color', 0.7 * cyan, 'LineWidth', 3);
xlim([-0.5 3.5]);
set(gca, 'XTick', nonNegativeplotValueDiffs, 'XTickLabel', ...
    nonNegativeplotValueDiffs);
xlabel('r_{closest} - r_{farthest}','FontSize', 24);
ylabel('First fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);


%% Histogram of middle fixations vs. value fixated minus value unfixated.

allCountMiddleFixations = zeros(length(valueDiffs), 1);

for i=1:length(parcodes)
    for s=sessions
        countMiddleFixations = NumMiddleFixationsVsValueFixMinusUnfix( ...
            valueDiffs, parcodes(i,:), s);

        for j=1:length(valueDiffs)
            allCountMiddleFixations(j) = allCountMiddleFixations(j) + ...
                countMiddleFixations(j);
        end
    end
end

figure;
bar(valueDiffs, allCountMiddleFixations, 'FaceColor', ...
    0.8 + 0.2 * cyan, 'EdgeColor', 0.7 * cyan, 'BarWidth', 0.4, ...
    'LineWidth', 3);
xlabel('r_{fixated} - r_{unfixated}', 'FontSize', 24);
ylabel('Number of middle fixations','FontSize', 24);
set(gca,'FontSize',20);

orient landscape
print('-dpsc2', '-append', plotsFileName);


%% Plot bar graph of fixation times for all fixation types.

allFirstFixTime = [];
allSecondFixTime = [];
allThirdFixTime = [];
allFourthFixTime = [];
allFifthFixTime = [];
allSixthFixTime = [];
allSeventhFixTime = [];
allEighthFixTime = [];
allNinthFixTime = [];
allTenthFixTime = [];
allOtherFixTime = [];

for i=1:length(parcodes)
    for s=sessions
        [firstFixTimes, secondFixTimes, thirdFixTimes, fourthFixTimes, ...
            fifthFixTimes, sixthFixTimes, seventhFixTimes, ...
            eighthFixTimes, ninthFixTimes, tenthFixTimes, ...
            otherFixTimes] = FixationDurationGroupedByType( ...
            parcodes(i,:), s);

        allFirstFixTime = [allFirstFixTime; firstFixTimes];
        allSecondFixTime = [allSecondFixTime; secondFixTimes];
        allThirdFixTime = [allThirdFixTime; thirdFixTimes];
        allFourthFixTime = [allFourthFixTime; fourthFixTimes];
        allFifthFixTime = [allFifthFixTime; fifthFixTimes];
        allSixthFixTime = [allSixthFixTime; sixthFixTimes];
        allSeventhFixTime = [allSeventhFixTime; seventhFixTimes];
        allEighthFixTime = [allEighthFixTime; eighthFixTimes];
        allNinthFixTime = [allNinthFixTime; ninthFixTimes];
        allTenthFixTime = [allTenthFixTime; tenthFixTimes];
        allOtherFixTime = [allOtherFixTime; otherFixTimes];
    end
end

means(1) = mean(allFirstFixTime);
confInts(1) = Get95PercConfidenceInterval(std(allFirstFixTime), ...
    length(allFirstFixTime));
stds(1) = std(allFirstFixTime);

means(2) = mean(allSecondFixTime);
confInts(2) = Get95PercConfidenceInterval(std(allSecondFixTime), ...
    length(allSecondFixTime));
stds(2) = std(allSecondFixTime);

means(3) = mean(allThirdFixTime);
confInts(3) = Get95PercConfidenceInterval(std(allThirdFixTime), ...
    length(allThirdFixTime));
stds(3) = std(allThirdFixTime);

means(4) = mean(allFourthFixTime);
confInts(4) = Get95PercConfidenceInterval(std(allFourthFixTime), ...
    length(allFourthFixTime));
stds(4) = std(allFourthFixTime);

means(5) = mean(allFifthFixTime);
confInts(5) = Get95PercConfidenceInterval(std(allFifthFixTime), ...
    length(allFifthFixTime));
stds(5) = std(allFifthFixTime);

means(6) = mean(allSixthFixTime);
confInts(6) = Get95PercConfidenceInterval(std(allSixthFixTime), ...
    length(allSixthFixTime));
stds(6) = std(allSixthFixTime);

means(7) = mean(allSeventhFixTime);
confInts(7) = Get95PercConfidenceInterval(std(allSeventhFixTime), ...
    length(allSeventhFixTime));
stds(7) = std(allSeventhFixTime);

means(8) = mean(allEighthFixTime);
confInts(8) = Get95PercConfidenceInterval(std(allEighthFixTime), ...
    length(allEighthFixTime));
stds(8) = std(allEighthFixTime);

means(9) = mean(allNinthFixTime);
confInts(9) = Get95PercConfidenceInterval(std(allNinthFixTime), ...
    length(allNinthFixTime));
stds(9) = std(allNinthFixTime);

means(10) = mean(allTenthFixTime);
confInts(10) = Get95PercConfidenceInterval(std(allTenthFixTime), ...
    length(allTenthFixTime));
stds(10) = std(allTenthFixTime);

means(11) = mean(allOtherFixTime);
confInts(11) = Get95PercConfidenceInterval(std(allOtherFixTime), ...
    length(allOtherFixTime));
stds(11) = std(allOtherFixTime);

figure; hold on;
bar(means, 'FaceColor', 0.8 + 0.2 * cyan, 'EdgeColor', 0.7 * cyan, ...
    'BarWidth', 0.4, 'LineWidth', 3);
errorbar(means, stds, '.', 'Color', 0.7 * cyan, 'LineWidth', 3);
set(gca,'XTick',1:11,'XTickLabel',{'1st', '2nd', '3rd', '4th', '5th', ...
    '6th', '7th', '8th', '9th', '10th', 'Other'});
ylabel('Fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

orient landscape
print('-dpsc2', '-append', plotsFileName);

figure; hold on;
bar(means, 'FaceColor', 0.8 + 0.2 * cyan, 'EdgeColor', 0.7 * cyan, ...
    'BarWidth', 0.4, 'LineWidth', 3);
errorbar(means, confInts, '.', 'Color', 0.7 * cyan, 'LineWidth', 3);
set(gca,'XTick',1:11,'XTickLabel',{'1st', '2nd', '3rd', '4th', '5th', ...
    '6th', '7th', '8th', '9th', '10th', 'Other'});
ylabel('Fixation duration [ms]','FontSize', 24);
set(gca,'FontSize',20);

fclose('all');
orient landscape
print('-dpsc2', '-append', plotsFileName);

close all

