function avgProbs = GetAvgProbChooseFirstFixByValueDiff(valueDiffs, ...
    valueLeft, valueRight, choice, fixItem, fixTime, parcodes, ...
    sessions, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcodes', 'var') && exist('sessions', 'var')
    trial = 1;
    for p=1:size(parcodes, 1)
        for s=sessions
            % Load file with experimental data.
            files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', ...
                parcodes(p,:), s));
            load(sprintf('expdata/%s', files(1).name));

            % Load eye tracking data.
            [time, ~, ~, item, ~] = ReadEyetrackingData(parcodes(p,:), s);

            for numBlock = 1:data.numBlocks
                angTarget = data.target(numBlock);
                for numTrial = 1:data.numTestTrials
                    if mod(numTrial,2) == 0 && oddTrialsOnly
                        continue;
                    end
                    if mod(numTrial,2) == 1 && evenTrialsOnly
                        continue;
                    end
                    distLeft = angTarget - data.left{numBlock}(numTrial);
                    distRight = angTarget - data.right{numBlock}(numTrial);
                    valueLeft(trial,1) = - abs(distLeft);
                    valueRight(trial,1) = - abs(distRight);
                    choice(trial,1) = ...
                        data.testResponseType{numBlock}(numTrial);
                    fixItem{trial,1} = item{numBlock,numTrial};
                    fixTime{trial,1} = time{numBlock,numTrial};
                    trial = trial + 1;
                end
            end
            fclose('all');
        end
    end
end

countChoseFirstFix = zeros(length(valueDiffs),1);
countTotal = zeros(length(valueDiffs),1);
for trial=1:length(valueLeft)
    for i=1:length(fixItem{trial,1})
        if fixItem{trial,1}(i) == 1
            firstFix = -1;
            vDiff = valueLeft(trial) - valueRight(trial);
            break;
        elseif fixItem{trial,1}(i) == 2
            firstFix = 1;
            vDiff = valueRight(trial) - valueLeft(trial);
            break;
        end
    end
%     vDiff = valueLeft(trial) - valueRight(trial);
    idx = find(valueDiffs==vDiff);
    
    countTotal(idx) = countTotal(idx) + 1;
    if choice(trial) == firstFix % choice was same as 1st fixated item
        countChoseFirstFix(idx) = countChoseFirstFix(idx) + 1;
    end
end
avgProbs = countChoseFirstFix ./ countTotal;

end