function timeAdvantageLeft = GetTimeAdvantageLeft(fixItem, fixTime, ...
    parcode, session, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    trial = 1;
    for numBlock = 1:data.numBlocks
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

timeAdvantageLeft = [];

for trial=1:length(fixItem)
    % Get total fixation time for each item.
    timeLeftFix = 0;
    timeRightFix = 0;

    for i = 1:length(fixItem{trial})
        if fixItem{trial}(i) == 1 % left item fixation
            timeLeftFix = timeLeftFix + fixTime{trial}(i);
        elseif fixItem{trial}(i) == 2 % right item fixation
            timeRightFix = timeRightFix + fixTime{trial}(i);
        end
    end

    % Get time advantage.
    timeDiff = timeLeftFix - timeRightFix;
    timeAdvantageLeft = [timeAdvantageLeft; timeDiff];
end
end