function [choice, rt, valueLeft, valueRight, fixItem, fixTime, ...
    countDiscarded, countEndInTransition, subjs] = GetValidDataTrials( ...
    parcodes, sessions, oddTrialsOnly, evenTrialsOnly, ...
    earlyMemoryTrialsOnly, lateMemoryTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end
if ~exist('earlyMemoryTrialsOnly', 'var')
    earlyMemoryTrialsOnly = false;
end
if ~exist('lateMemoryTrialsOnly', 'var')
    lateMemoryTrialsOnly = false;
end

choice = [];
rt = [];
valueLeft = [];
valueRight = [];
fixItem = {};
fixTime = {};
subjs = [];

trialCount = 1;
countDiscarded = zeros(size(parcodes,1),1);
countEndInTransition = zeros(size(parcodes,1),1);
for p=1:size(parcodes,1)
    for s=sessions
        % Load file with experimental data.
        files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', ...
            parcodes(p,:), s));
        load(sprintf('expdata/%s', files(1).name));

        % Load eye tracking data.
        [time, ~, ~, item, duration, transition] = ...
            ReadEyetrackingData(parcodes(p,:), s);
        
        for numBlock = 1:data.numBlocks
            angTarget = data.target(numBlock);
            for numTrial = 1:data.numTestTrials
                if mod(numTrial,2) == 0 && oddTrialsOnly
                    continue;
                end
                if mod(numTrial,2) == 1 && evenTrialsOnly
                    continue;
                end
                
%                 if earlyMemoryTrialsOnly && ...
%                         ~(mod(numTrial-1,5)==0 || mod(numTrial-2,5)==0)
%                     continue;
%                 end
%                 if lateMemoryTrialsOnly && ...
%                         ~(mod(numTrial-4,5)==0 || mod(numTrial,5)==0)
%                     continue;
%                 end
                if earlyMemoryTrialsOnly && ~(mod(numTrial-1,5)==0)
                    continue;
                end
                if lateMemoryTrialsOnly && ~(mod(numTrial,5)==0)
                    continue;
                end

                % Check if trial is valid.
                if (transition(numBlock,numTrial) / ...
                        duration(numBlock, numTrial)) >= 0.5
                    countDiscarded(p,1) = countDiscarded(p,1) + 1;
                    continue;
                end
                if isempty(find(item{numBlock,numTrial}==1 | ...
                        item{numBlock,numTrial}==2, 1))
                    continue;
                end
                
                if item{numBlock,numTrial}(end) ~= 1 && ...
                        item{numBlock,numTrial}(end) ~= 2
                    countEndInTransition(p,1) = ...
                        countEndInTransition(p,1) + 1;
                end
                distLeft = angTarget - data.left{numBlock}(numTrial);
                distRight = angTarget - data.right{numBlock}(numTrial);
                choice(trialCount,1) = ...
                    data.testResponseType{numBlock}(numTrial);
                rt(trialCount,1) = duration(numBlock,numTrial);
                valueLeft(trialCount,1) = - abs(distLeft);
                valueRight(trialCount,1) = - abs(distRight);
                fixItem{trialCount,1} = item{numBlock,numTrial};
                fixTime{trialCount,1} = time{numBlock,numTrial};
                subjs(trialCount,1) = p;
                trialCount = trialCount + 1;
            end
        end
        fclose('all');
    end
end
end