close all
clear
clc

values = 0:1:3;
valueDiffs = -3:1:3;
positiveValueDiffs = 1:1:3;
nonNegativeValueDiffs = 0:1:3;
xLim = [-3.5 3.5];

sessions = 1:4;
parcodes = ['mar'; 'sol'; 'lua'; 'rio'; 'cor'; 'sal'; 'mel'; 'dia'; ...
    'ceu'; 'lei'; 'fio'; 'sul'; 'vai'; 'pai'; 'reu'; 'cai'; 'rei'; ...
    'dor'; 'giz'; 'mae'; 'tia'; 'pia'; 'fui'; 'gol'; 'gel'];

% Load all data.
[dataChoice, dataRt, dataValueLeft, dataValueRight, dataFixItem, ...
    dataFixTime, ~, ~, subjs] = GetValidDataTrials(parcodes, sessions);
dataValueLeft = (dataValueLeft ./ 5) + 3;
dataValueRight = (dataValueRight ./ 5) + 3;

% RTs.
rtMeans = [];
for s=1:size(parcodes,1)
    rtMeans = [rtMeans; mean(dataRt(subjs==s))];
end
mean(rtMeans)
std(rtMeans)
    

% Percentage of correct choice.
countCorrect = zeros(size(parcodes,1), 1);
countTotal = zeros(size(parcodes,1), 1);
for i=1:length(dataChoice)
    s = subjs(i);
    countTotal(s) = countTotal(s) + 1;
    if dataChoice(i) == -1 % choice left
        if dataValueLeft(i) >= dataValueRight(i)
            countCorrect(s) = countCorrect(s) + 1;
        end
    elseif dataChoice(i) == 1 % choice right
        if dataValueRight(i) >= dataValueLeft(i)
            countCorrect(s) = countCorrect(s) + 1;
        end
    end
end
percCorrect = [];
for s=1:size(parcodes,1)
    percCorrect = [percCorrect; countCorrect(s)/countTotal(s)];
end
mean(percCorrect)
std(percCorrect)

% Number of fixations.
numFixMeans = [];
for s=1:size(parcodes,1)
    idx = find(subjs==s);
    subjItems = dataFixItem(idx,1);
    subjNumFix = [];
    for i=1:length(subjItems)
        idx = find(subjItems{i}==1 | subjItems{i}==2);
        numFix = length(subjItems{i}(idx));
        subjNumFix = [subjNumFix; numFix];
    end
    numFixMeans = [numFixMeans; mean(subjNumFix)];
end
mean(numFixMeans)
std(numFixMeans)

