function lastFixTimes = LastFixTimeVsValueBestMinusWorst(parcode, ...
    sessn, valueDiffs)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Read eyetracking data.
[fixTime, ~, ~, fixItem, ~, ~] = ReadEyetrackingData(parcode, sessn);

lastFixTimes = cell(length(valueDiffs), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);

        if valueLeft >= valueRight
            valueDiff = valueLeft - valueRight;
        elseif valueRight > valueLeft
            valueDiff = valueRight - valueLeft;
        end

        idx = find(valueDiffs==valueDiff);
        
        for i=length(fixItem{numBlock,numTrial}):-1:1
            if fixItem{numBlock,numTrial}(i) == 1 || ...
                    fixItem{numBlock,numTrial}(i) == 2
                lastFixTimes{idx} = [lastFixTimes{idx}; ...
                    fixTime{numBlock,numTrial}(i)];
                break;
            end
        end
    end
end
end
