function [lastFixTimesChoseFixed, lastFixTimesChoseUnfixed] = ...
    LastFixationDurationGroupedByChoice(choice, fixItem, fixTime, ...
    parcode, session)

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    fixItem = cell(data.numBlocks * data.numTestTrials, 1);
    fixTime = cell(data.numBlocks * data.numTestTrials, 1);
    choice = zeros(data.numBlocks * data.numTestTrials, 1);
    trial = 1;
    for numBlock = 1:data.numBlocks
        for numTrial = 1:data.numTestTrials
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

selectFixItem = cell(size(fixItem));
selectFixTime = cell(size(fixTime));

% Select only fixations to right or left item.
for numTrial=1:length(fixItem)
    idx = find(fixItem{numTrial} == 1 | fixItem{numTrial} == 2);
    selectFixTime{numTrial} = fixTime{numTrial}(idx);
    selectFixItem{numTrial} = fixItem{numTrial}(idx);
end

lastFixTimesChoseFixed = [];
lastFixTimesChoseUnfixed = [];

for numTrial=1:length(selectFixItem)
    if length(selectFixItem{numTrial}) < 1
        continue;
    end
    
    % Choice was left.
    if choice(numTrial) == -1
        % Last fixation was left.
        if selectFixItem{numTrial}(end) == 1
            lastFixTimesChoseFixed = [lastFixTimesChoseFixed; ...
                selectFixTime{numTrial}(end)];
        % Last fixation was right.
        elseif selectFixItem{numTrial}(end) == 2
            lastFixTimesChoseUnfixed = [lastFixTimesChoseUnfixed; ...
                selectFixTime{numTrial}(end)];
        end
    % Choice was right.
    elseif choice(numTrial) == 1
        % Last fixation was left.
        if selectFixItem{numTrial}(end) == 1
            lastFixTimesChoseUnfixed = [lastFixTimesChoseUnfixed; ...
                selectFixTime{numTrial}(end)];
        % Last fixation was right.
        elseif selectFixItem{numTrial}(end) == 2
            lastFixTimesChoseFixed = [lastFixTimesChoseFixed; ...
                selectFixTime{numTrial}(end)];
        end
    end
end

end
