function [secondFixTimeValFix, secondFixTimeValNonFix, ...
    thirdFixTimeValFix, thirdFixTimeValNonFix, otherFixTimeValFix, ...
    otherFixTimeValNonFix] = MiddleFixDurationVsItemValue(parcode, ...
    sessn, values, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Load eye tracking data.
[fixTime, ~, ~, fixItem, ~] = ReadEyetrackingData(parcode, sessn);

selectFixTime = cell(data.numBlocks, data.numTestTrials);
selectFixItem = cell(data.numBlocks, data.numTestTrials);

% Select only fixations to right or left item
for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        idx = find(fixItem{numBlock,numTrial} == 1 | ...
            fixItem{numBlock,numTrial} == 2);
        selectFixTime{numBlock,numTrial} = fixTime{numBlock,numTrial}(idx);
        selectFixItem{numBlock,numTrial} = fixItem{numBlock,numTrial}(idx);
    end
end

secondFixTimeValFix = cell(length(values), 1);
secondFixTimeValNonFix = cell(length(values), 1);
thirdFixTimeValFix = cell(length(values), 1);
thirdFixTimeValNonFix = cell(length(values), 1);
otherFixTimeValFix = cell(length(values), 1);
otherFixTimeValNonFix = cell(length(values), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        if mod(numTrial,2) == 0 && oddTrialsOnly
            continue;
        end
        if mod(numTrial,2) == 1 && evenTrialsOnly
            continue;
        end

        % Calculate values of fixated and non-fixated items in this trial.
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        valueLeft = (valueLeft / 5) + 3;
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueRight = (valueRight / 5) + 3;
        
        if length(selectFixItem{numBlock,numTrial}) < 3
            continue;
        end
        % Get second fixation.
        if selectFixItem{numBlock,numTrial}(2) == 1 % LEFT
            valueFix = valueLeft;
            valueNonFix = valueRight;
        else % RIGHT
            valueFix = valueRight;
            valueNonFix = valueLeft;
        end
        idxFix = find(values==valueFix);
        idxNonFix = find(values==valueNonFix);
        secondFixTimeValFix{idxFix} = [secondFixTimeValFix{idxFix}; ...
            selectFixTime{numBlock,numTrial}(2)];
        secondFixTimeValNonFix{idxNonFix} = ...
            [secondFixTimeValNonFix{idxNonFix}; ...
            selectFixTime{numBlock,numTrial}(2)];

        if length(selectFixItem{numBlock,numTrial}) < 4
            continue;
        end
        % Get third fixation.
        if selectFixItem{numBlock,numTrial}(3) == 1 % LEFT
            valueFix = valueLeft;
            valueNonFix = valueRight;
        else % RIGHT
            valueFix = valueRight;
            valueNonFix = valueLeft;
        end
        idxFix = find(values==valueFix);
        idxNonFix = find(values==valueNonFix);
        thirdFixTimeValFix{idxFix} = [thirdFixTimeValFix{idxFix}; ...
            selectFixTime{numBlock,numTrial}(3)];
        thirdFixTimeValNonFix{idxNonFix} = ...
            [thirdFixTimeValNonFix{idxNonFix}; ...
            selectFixTime{numBlock,numTrial}(3)];

        if length(selectFixItem{numBlock,numTrial}) < 5
            continue;
        end
        % Get other middle fixations.
        for i = 4:length(selectFixTime{numBlock,numTrial})-1
            if selectFixItem{numBlock,numTrial}(i) == 1 % LEFT
                valueFix = valueLeft;
                valueNonFix = valueRight;
                else % RIGHT
                valueFix = valueRight;
                valueNonFix = valueLeft;
            end
            idxFix = find(values==valueFix);
            idxNonFix = find(values==valueNonFix);
            otherFixTimeValFix{idxFix} = [otherFixTimeValFix{idxFix}; ...
                selectFixTime{numBlock,numTrial}(i)];
            otherFixTimeValNonFix{idxNonFix} = ...
                [otherFixTimeValNonFix{idxNonFix}; ...
                selectFixTime{numBlock,numTrial}(i)];
        end
    end
end
end
