function [numFixationsChoseFixed, numFixationsChoseUnfixed] = ...
    NumFixationsByChoiceAndValueDiff(valueDiffs, choice, fixItem, ...
    fixTime, valueLeft, valueRight, parcode, session)

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    fixItem = cell(data.numBlocks * data.numTestTrials, 1);
    fixTime = cell(data.numBlocks * data.numTestTrials, 1);
    choice = zeros(data.numBlocks * data.numTestTrials, 1);
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            angLeft = data.left{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(angTarget - angLeft);
            angRight = data.right{numBlock}(numTrial);
            valueRight(trial,1) = - abs(angTarget - angRight);
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

selectFixItem = cell(length(fixItem),1);
selectFixTime = cell(length(fixTime),1);

% Select only fixations to right or left item.
for numTrial=1:length(fixItem)
    idx = find(fixItem{numTrial} == 1 | fixItem{numTrial} == 2);
    selectFixTime{numTrial} = fixTime{numTrial}(idx);
    selectFixItem{numTrial} = fixItem{numTrial}(idx);
end

numFixationsChoseFixed = cell(length(valueDiffs), 1);
numFixationsChoseUnfixed = cell(length(valueDiffs), 1);

for numTrial=1:length(selectFixItem)
    if length(selectFixItem{numTrial}) <= 1
        continue;
    end
    valueDiff = abs(valueLeft(numTrial) - valueRight(numTrial));
    idx = find(valueDiffs==valueDiff);

    % Choice was left.
    if choice(numTrial) == -1
        % Last fixation was left.
        if selectFixItem{numTrial}(end) == 1
            numFixationsChoseFixed{idx} = [numFixationsChoseFixed{idx}; ...
                length(selectFixItem{numTrial})];
        % Last fixation was right.
        elseif selectFixItem{numTrial}(end) == 2
            numFixationsChoseUnfixed{idx} = ...
                [numFixationsChoseUnfixed{idx}; ...
                length(selectFixItem{numTrial})];
        end
    % Choice was right.
    elseif choice(numTrial) == 1
        % Last fixation was left.
        if selectFixItem{numTrial}(end) == 1
            numFixationsChoseUnfixed{idx} = ...
                [numFixationsChoseUnfixed{idx}; ...
                length(selectFixItem{numTrial})];
        % Last fixation was right.
        elseif selectFixItem{numTrial}(end) == 2
            numFixationsChoseFixed{idx} = [numFixationsChoseFixed{idx}; ...
                length(selectFixItem{numTrial})];
        end
    end
end
end
