function fixations = NumFixationsVsValueBestMinusWorst(valueDiffs, ...
    fixItem, valueLeft, valueRight, parcode, session, oddTrialsOnly, ...
    evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));
    
    % Load eye tracking data.
    [~, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            angLeft = data.left{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(angTarget - angLeft);
            angRight = data.right{numBlock}(numTrial);
            valueRight(trial,1) = - abs(angTarget - angRight);
            fixItem{trial,1} = item{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

fixations = cell(length(valueDiffs), 1);

for numTrial=1:length(fixItem)
    numFixations = 0;
    for i = 1:length(fixItem{numTrial})
        if fixItem{numTrial}(i) == 1 || fixItem{numTrial}(i) == 2
            numFixations = numFixations + 1;
        end
    end

    if valueLeft(numTrial) >= valueRight(numTrial)
        valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    elseif valueRight(numTrial) > valueLeft(numTrial)
        valueDiff = valueRight(numTrial) - valueLeft(numTrial);
    end
    idx = find(valueDiffs==valueDiff);
    fixations{idx} = [fixations{idx}; numFixations];
end
end
