function [fixationsCis, fixationsTrans] = ...
    NumFixationsVsValueDiffByCisTrans(parcode, sessn, valueDiffs)

% CIS: R<L<T or L<R<T; T<L<R or T<R<L 
% TRANS: L<T<R or R<T<L

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Load eye tracking data.
[~, ~, ~, fixItem, ~] = ReadEyetrackingData(parcode, sessn);

% Count fixations in each trial.
numFixations = zeros(data.numBlocks, data.numTestTrials);

for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        for i = 1:length(fixItem{numBlock,numTrial})
            if fixItem{numBlock,numTrial}(i) == 1 || ...
                    fixItem{numBlock,numTrial}(i) == 2 % left or right
                numFixations(numBlock,numTrial) = ...
                    numFixations(numBlock,numTrial) + 1;
            end
        end
    end
end

% Group trials based on category.
fixationsCis = cell(length(valueDiffs), 1);
fixationsTrans = cell(length(valueDiffs), 1);


for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);

    for numTrial = 1:data.numTestTrials
        % Calculate distance from target for left and right stimuli.
        angLeft = data.left{numBlock}(numTrial);
        distLeft = angTarget - angLeft;
        valueLeft = - abs(distLeft);
        angRight = data.right{numBlock}(numTrial);
        distRight = angTarget - angRight;
        valueRight = - abs(distRight);
        
        valueDiff = valueLeft - valueRight;
        idx = find(valueDiffs==valueDiff);
        
        if distLeft > 0 && distRight > 0 % Cis
            fixationsCis{idx} = [fixationsCis{idx}; ...
                numFixations(numBlock,numTrial)];
        elseif distLeft < 0 && distRight < 0 % Cis
            fixationsCis{idx} = [fixationsCis{idx}; ...
                numFixations(numBlock,numTrial)];
        else % Trans
            fixationsTrans{idx} = [fixationsTrans{idx}; ...
                numFixations(numBlock,numTrial)];
        end
    end
end
end
