function countMiddleFixations = NumMiddleFixationsVsValueFixMinusUnfix( ...
    valueDiffs, parcode, session, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            angLeft = data.left{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(angTarget - angLeft);
            valueLeft(trial,1) = (valueLeft(trial,1) / 5) + 3;
            angRight = data.right{numBlock}(numTrial);
            valueRight(trial,1) = - abs(angTarget - angRight);
            valueRight(trial,1) = (valueRight(trial,1) / 5) + 3;
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

selectFixItem = cell(size(fixTime));

% Select only fixations to right or left item.
for numTrial=1:length(fixItem)
    selectFixItem{numTrial} = ...
        fixItem{numTrial}(fixItem{numTrial} == 1 | fixItem{numTrial} == 2);
end

countMiddleFixations = zeros(length(valueDiffs), 1);

for numTrial=1:length(selectFixItem)
    if length(selectFixItem{numTrial}) < 3
        continue;
    end
    % Get middle fixations.
    for i=2:length(selectFixItem{numTrial})-1
        if selectFixItem{numTrial}(i) == 1
            valueDiff = valueLeft(numTrial) - valueRight(numTrial);
        elseif selectFixItem{numTrial}(i) == 2
            valueDiff = valueRight(numTrial) - valueLeft(numTrial);
        end
        idx = find(valueDiffs==valueDiff);
        countMiddleFixations(idx) = countMiddleFixations(idx) + 1;
    end
end
end
