function PlotFixationData(parcode, sessn, valueDiffs)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Load eye tracking data.
[fixTime, ~, ~, fixItem, ~] = ReadEyetrackingData(parcode, sessn);

rectX = cell(data.numBlocks*data.numTestTrials,1);
rectWidth = cell(data.numBlocks*data.numTestTrials,1);
rectColor = cell(data.numBlocks*data.numTestTrials,1);
firstFixItem = zeros(data.numBlocks*data.numTestTrials,1);
firstFixTime = zeros(data.numBlocks*data.numTestTrials,1);

valueDiff = ones(3*data.numTestTrials,1);

figure; hold on;
trialCount = 1;

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);

    for numTrial = 1:data.numTestTrials
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueDiff(trialCount) = valueLeft - valueRight;
        
        if ~isempty(fixItem{numBlock,numTrial})
            firstFixItem(trialCount) = fixItem{numBlock,numTrial}(1);
            firstFixTime(trialCount) = fixTime{numBlock,numTrial}(1);
        end
        
        x = 0;
        for fix=1:length(fixTime{numBlock,numTrial})
            item = fixItem{numBlock,numTrial}(fix);
            color = [0.5 0.5 0.5];
            if item == 1 % LEFT will be red
                color = [1 0 0];
            elseif item == 2 % RIGHT will be green
                color = [0 1 0];
            elseif item == 3 % CENTER will be black
                color = [0 0 0];
            end

            width = fixTime{numBlock,numTrial}(fix);
            
            rectX{trialCount} = [rectX{trialCount}; x];
            rectWidth{trialCount} = [rectWidth{trialCount}; width];
            rectColor{trialCount} = [rectColor{trialCount}; color];
            
            x = x + width;
        end
        
        trialCount = trialCount + 1;
    end
end

y = 0;
yTick = [];
for i=1:length(valueDiffs)
    yTick = [yTick; y];

    diff = valueDiffs(i);
    idx = find(valueDiff==diff);
    
    % Select necessary info for trials with this value difference.
    x = rectX(idx);
	width = rectWidth(idx);
    color = rectColor(idx);
    item = firstFixItem(idx);
    time = firstFixTime(idx);
    
    % Separate necessary info for left, right and other trials. 
    leftTime = time(find(item==1));
    rightTime = time(find(item==2));
    centerTime = time(find(item==3));
    otherTime = time(find(item~=1 & item~=2 & item~=3));
    
    leftX = x(find(item==1));
    rightX = x(find(item==2));
    centerX = x(find(item==3));
    otherX = x(find(item~=1 & item~=2 & item~=3));
    
    leftWidth = width(find(item==1));
    rightWidth = width(find(item==2));
    centerWidth = width(find(item==3));
    otherWidth = width(find(item~=1 & item~=2 & item~=3));
    
    leftColor = color(find(item==1));
    rightColor = color(find(item==2));
    centerColor = color(find(item==3));
    otherColor = color(find(item~=1 & item~=2 & item~=3));
    
    [~, sortedIdxLeft] = sort(leftTime);
    [~, sortedIdxRight] = sort(rightTime);
    [~, sortedIdxCenter] = sort(centerTime);
    [~, sortedIdxOther] = sort(otherTime);
        
    % Iterate over trials with specific value difference.
    % Start with first fixation left trials.
    for j=1:length(sortedIdxLeft)
        currIdx = sortedIdxLeft(j);
        for k=1:length(leftX{currIdx})
            rectangle('Position', [leftX{currIdx}(k) y ...
                leftWidth{currIdx}(k) 1], 'FaceColor', ...
                leftColor{currIdx}(k,:), 'EdgeColor', 'None');
        end
        y = y + 1;
    end
    % Now do first fixation right trials.
    for j=1:length(sortedIdxRight)
        currIdx = sortedIdxRight(j);
        for k=1:length(rightX{currIdx})
            rectangle('Position', [rightX{currIdx}(k) y ...
                rightWidth{currIdx}(k) 1], 'FaceColor', ...
                rightColor{currIdx}(k,:), 'EdgeColor', 'None');
        end
        y = y + 1;
    end
    % Now do first fixation center trials.
    for j=1:length(sortedIdxCenter)
        currIdx = sortedIdxCenter(j);
        for k=1:length(centerX{currIdx})
            rectangle('Position', [centerX{currIdx}(k) y ...
                centerWidth{currIdx}(k) 1], 'FaceColor', ...
                centerColor{currIdx}(k,:), 'EdgeColor', 'None');
        end
        y = y + 1;
    end
    % Now do other first fixation trials.
    for j=1:length(sortedIdxOther)
        currIdx = sortedIdxOther(j);
        for k=1:length(otherX{currIdx})
            if otherWidth{currIdx}(k) > 0
                rectangle('Position', [otherX{currIdx}(k) y ...
                    otherWidth{currIdx}(k) 1], 'FaceColor', ...
                    otherColor{currIdx}(k,:), 'EdgeColor', 'None');
            end
        end
        y = y + 1;
    end
    
    % Go to next group of trials (with next value difference).
    y = y + 3;
end

xlim([0 12000]);
ylim([0 y]);
xlabel('Time [ms]','FontSize', 20);
ylabel('Trials grouped by value difference','FontSize', 20);
title(['Subject ' parcode ', session ' num2str(sessn)],'FontSize', 20);
set(gca,'YTick',yTick);
set(gca,'YTickLabel',{'-15';'-10';'-5';'0';'+5';'+10';'+15'});
set(gca,'FontSize',18);

end
