function [countChoseFirst, countTotal] = ...
    ProbChooseFirstVsTimeFirstFix(timeBins, choice, fixItem, ...
    fixTime, parcode, session, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    choice = [];
    fixItem = {};
    fixTime = {};
    trial = 1;
    for numBlock = 1:data.numBlocks
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

countChoseFirst = zeros(length(timeBins), 1);
countTotal = zeros(length(timeBins), 1);

for trial=1:length(choice)
    timeFirstFix = 0;
    firstFixItem = 0;
    for i = 1:length(fixItem{trial})
        if fixItem{trial}(i) == 1 % left item fixation
            timeFirstFix = fixTime{trial}(i);
            firstFixItem = 1;
            break;
        elseif fixItem{trial}(i) == 2 % right item fixation
            timeFirstFix = fixTime{trial}(i);
            firstFixItem = 2;
            break;
        end
    end

    % Get first fix time bin.
    bin = 1;
    for i=1:length(timeBins)-1
        if timeFirstFix >= timeBins(i) && timeFirstFix < timeBins(i+1)
            bin = i;
            break;
        end
    end
    if timeFirstFix >= timeBins(end)
        bin = length(timeBins);
    end
    
    % Check decision.
    countTotal(bin) = countTotal(bin) + 1;
    if choice(trial) == -1 && firstFixItem == 1 % choice + 1st fix left 
        countChoseFirst(bin) = countChoseFirst(bin) + 1;
    elseif choice(trial) == 1 && firstFixItem == 2 % choice + 1st fix right 
        countChoseFirst(bin) = countChoseFirst(bin) + 1;
    end
end
end