function [countChoseFirst, countTotal] = ...
    ProbChooseFirstVsValueFixMinusUnfix(valueDiffs, valueLeft, ...
    valueRight, choice, fixItem, fixTime, parcode, session, ...
    oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            distLeft = angTarget - data.left{numBlock}(numTrial);
            distRight = angTarget - data.right{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(distLeft);
            valueRight(trial,1) = - abs(distRight);
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

countChoseFirst = zeros(length(valueDiffs), 1);
countTotal = zeros(length(valueDiffs), 1);

for trial=1:length(choice)
    valueDiff = 0;
    firstFixItem = 0;
    for i = 1:length(fixItem{trial})
        if fixItem{trial}(i) == 1 % left item fixation
            valueDiff = valueLeft(trial) - valueRight(trial);
            firstFixItem = 1;
            break;
        elseif fixItem{trial}(i) == 2 % right item fixation
            valueDiff = valueRight(trial) - valueLeft(trial);
            firstFixItem = 2;
            break;
        end
    end
    idx = find(valueDiffs==valueDiff);
    
    % Check decision.
    countTotal(idx) = countTotal(idx) + 1;
    if choice(trial) == -1 && firstFixItem == 1 % choice + 1st fix left 
        countChoseFirst(idx) = countChoseFirst(idx) + 1;
    elseif choice(trial) == 1 && firstFixItem == 2 % choice + 1st fix right 
        countChoseFirst(idx) = countChoseFirst(idx) + 1;
    end
end
end