function [countChooseLeft, countLeftFirst, countTotal] = ...
    ProbChooseLeftAndProbLookLeftFirst(choice, fixItem, parcode, session)

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [~, ~, ~, item, ~, ~] = ReadEyetrackingData(parcode, session);
    
    choice = zeros(data.numBlocks * data.numTestTrials, 1);
    fixItem = cell(data.numBlocks * data.numTestTrials, 1);
    trial = 1;
    for numBlock = 1:data.numBlocks
        for numTrial = 1:data.numTestTrials
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

countChooseLeft = 0;
countLeftFirst = 0;
countTotal = 0;

for trial=1:length(choice)
    countTotal = countTotal + 1;

    if choice(trial) == -1
        countChooseLeft = countChooseLeft + 1;
    end

    for i = 1:length(fixItem{trial})
        if fixItem{trial}(i) == 1 || fixItem{trial}(i) == 2
            if fixItem{trial}(i) == 1 % looked left first
                countLeftFirst = countLeftFirst + 1;
            end
            break;
        end
    end
end
end