function [countChoseLeft, countTotal] = ...
    ProbChooseLeftVsTimeAdvantageLeft(timeBins, choice, fixItem, ...
    fixTime, parcode, session, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    trial = 1;
    for numBlock = 1:data.numBlocks
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

countChoseLeft = zeros(length(timeBins), 1);
countTotal = zeros(length(timeBins), 1);

for trial=1:length(choice)
    % Get total fixation time for each item.
    timeLeftFix = 0;
    timeRightFix = 0;

    for i = 1:length(fixItem{trial})
        if fixItem{trial}(i) == 1 % left item fixation
            timeLeftFix = timeLeftFix + fixTime{trial}(i);
        elseif fixItem{trial}(i) == 2 % right item fixation
            timeRightFix = timeRightFix + fixTime{trial}(i);
        end
    end

    % Get time advantage bin.
    timeDiff = timeLeftFix - timeRightFix;
    bin = 1;
    for i=1:length(timeBins)-1
        if timeDiff >= timeBins(i) && timeDiff < timeBins(i+1)
            bin = i+1;
            break;
        end
    end
    if timeDiff >= timeBins(end)
        bin = length(timeBins);
    end
    
    % Check decision.
    countTotal(bin) = countTotal(bin) + 1;
    if choice(trial) == -1 % choice was left
        countChoseLeft(bin) = countChoseLeft(bin) + 1;
    end
end
end