function [countError, countTotal] = ...
    ProbErrorGroupedVsValueBestMinusWorst(valueDiffs, choice, ...
    valueLeft, valueRight, parcode, session, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            angLeft = data.left{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(angTarget - angLeft);
            angRight = data.right{numBlock}(numTrial);
            valueRight(trial,1) = - abs(angTarget - angRight);
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            trial = trial + 1;
        end
    end
    fclose('all');
end

countError = zeros(length(valueDiffs),1);
countTotal = zeros(length(valueDiffs),1);

for numTrial=1:length(choice)
    vDiff = abs(valueLeft(numTrial) - valueRight(numTrial));
    idx = find(valueDiffs==vDiff);
    
    correct = 0;
    if valueLeft(numTrial) > valueRight(numTrial)
        correct = -1;
    elseif valueRight(numTrial) > valueLeft(numTrial)
        correct = 1;
    end

    countTotal(idx) = countTotal(idx) + 1;

    % Choice was left.
    if choice(numTrial) == -1
        % Correct choice was right.
        if correct == 1
            countError(idx) = countError(idx) + 1;
        end
    % Choice was right.
    elseif choice(numTrial) == 1
        % Correct choice was left.
        if correct == -1
            countError(idx) = countError(idx) + 1;
        end
    end
end
end
