function [countTotal, countBestFirst] = ...
    ProbFixateBestItemFirstVsBestMinusWorst(parcode, sessn, valueDiffs, ...
    oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));

% Load eye tracking data.
[~, ~, ~, fixItem, ~] = ReadEyetrackingData(parcode, sessn);

countTotal = zeros(length(valueDiffs), 1);
countBestFirst = zeros(length(valueDiffs), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    
    for numTrial = 1:data.numTestTrials
        if mod(numTrial,2) == 0 && oddTrialsOnly
            continue;
        end
        if mod(numTrial,2) == 1 && evenTrialsOnly
            continue;
        end
        bestItem = 0;
        valueBest = -100;
        valueWorst = -100;

        % Get item values for this trial.
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        valueLeft = (valueLeft / 5) + 3;
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueRight = (valueRight / 5) + 3;
        if valueLeft > valueRight
            valueBest = valueLeft;
            valueWorst = valueRight;
            bestItem = 1;
        elseif valueRight > valueLeft
            valueBest = valueRight;
            valueWorst = valueLeft;
            bestItem = 2;
        end
        
        valueDiff = valueBest - valueWorst;
        idx = find(valueDiffs==valueDiff);
        
        for i = 1:length(fixItem{numBlock,numTrial})
            if fixItem{numBlock,numTrial}(i) == 1 % first item is LEFT
                if bestItem == 1 || bestItem == 2
                    countTotal(idx) = countTotal(idx) + 1;
                    if bestItem == 1
                        countBestFirst(idx) = countBestFirst(idx) + 1;
                    end
                end
                break;
            elseif fixItem{numBlock,numTrial}(i) == 2 % first item is RIGHT
                if bestItem == 1 || bestItem == 2
                    countTotal(idx) = countTotal(idx) + 1;
                    if bestItem == 2
                        countBestFirst(idx) = countBestFirst(idx) + 1;
                    end
                end
                break;
            end
        end
    end
end
end
