function [countTotalValLeft, countLeftFirstValLeft, ...
    countRightFirstValLeft, countTotalValRight, countLeftFirstValRight, ...
    countRightFirstValRight] = ProbFixateItemFirstVsItemValue(parcode, ...
    sessn, values)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Load eye tracking data.
[~, ~, ~, fixItem, ~] = ReadEyetrackingData(parcode, sessn);

% Get first fixated item of each trial.
firstFixatedItem = zeros(data.numBlocks, data.numTestTrials);


for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        for i = 1:length(fixItem{numBlock,numTrial})
            if fixItem{numBlock,numTrial}(i) == 1 % first item is LEFT
                firstFixatedItem(numBlock,numTrial) = 1;
                break;
            elseif fixItem{numBlock,numTrial}(i) == 2 % first item is RIGHT
                firstFixatedItem(numBlock,numTrial) = 2;
                break;
            end
        end
    end
end

countTotalValLeft = zeros(length(values), 1);
countLeftFirstValLeft = zeros(length(values), 1);
countRightFirstValLeft = zeros(length(values), 1);

countTotalValRight = zeros(length(values), 1);
countLeftFirstValRight = zeros(length(values), 1);
countRightFirstValRight = zeros(length(values), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        % Calculate value difference for this trial.
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        valueLeft = (valueLeft / 5) + 3;
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueRight = (valueRight / 5) + 3;
        idxLeft = find(values==valueLeft);
        idxRight = find(values==valueRight);

        % Add trial based on first fixated item and item values.
        if firstFixatedItem(numBlock,numTrial) == 1 || ...
                firstFixatedItem(numBlock,numTrial) == 2 % left or right
            countTotalValLeft(idxLeft) = countTotalValLeft(idxLeft) + 1;
            countTotalValRight(idxRight) = ...
                countTotalValRight(idxRight) + 1;
        end
        if firstFixatedItem(numBlock,numTrial) == 1 % 1st fixated left
            countLeftFirstValLeft(idxLeft) = ...
                countLeftFirstValLeft(idxLeft) + 1;
            countLeftFirstValRight(idxRight) = ...
                countLeftFirstValRight(idxRight) + 1;
        elseif firstFixatedItem(numBlock,numTrial) == 2 % 1st fixated right
            countRightFirstValLeft(idxLeft) = ...
                countRightFirstValLeft(idxLeft) + 1;
            countRightFirstValRight(idxRight) = ...
                countRightFirstValRight(idxRight) + 1;
        end
    end
end
end
