function [countTotal, countLeftFirst, countRightFirst] = ...
    ProbFixateItemFirstVsValueDiff(parcode, sessn, valueDiffs)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Load eye tracking data.
[~, ~, ~, fixItem, ~] = ReadEyetrackingData(parcode, sessn);

% Get first fixated item of each trial.
firstFixatedItem = zeros(data.numBlocks, data.numTestTrials);


for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        for i = 1:length(fixItem{numBlock,numTrial})
            if fixItem{numBlock,numTrial}(i) == 1 % first item is LEFT
                firstFixatedItem(numBlock,numTrial) = 1;
                break;
            elseif fixItem{numBlock,numTrial}(i) == 2 % first item is RIGHT
                firstFixatedItem(numBlock,numTrial) = 2;
                break;
            end
        end
    end
end

countTotal = zeros(length(valueDiffs), 1);
countLeftFirst = zeros(length(valueDiffs), 1);
countRightFirst = zeros(length(valueDiffs), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);

    for numTrial = 1:data.numTestTrials
        % Calculate value difference for this trial.
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        valueLeft = (valueLeft / 5) + 3;
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueRight = (valueRight / 5) + 3;

        valueDiff = valueLeft - valueRight;
        idx = find(valueDiffs==valueDiff);
        
        % Add trial based on first fixated item and value difference.
        if firstFixatedItem(numBlock,numTrial) == 1 || ...
                firstFixatedItem(numBlock,numTrial) == 2 % left or right
            countTotal(idx) = countTotal(idx) + 1;
        end
        if firstFixatedItem(numBlock,numTrial) == 1 % 1st fixated left
            countLeftFirst(idx) = countLeftFirst(idx) + 1;
        elseif firstFixatedItem(numBlock,numTrial) == 2 % 1st fixated right
            countRightFirst(idx) = countRightFirst(idx) + 1;
        end
    end
end
end
