function [countLastFixToChosen, countTotal] = ...
    ProbLastFixIsToChosenItemVsValueLastSeenMinusOther(valueDiffs, ...
    fixItem, choice, valueLeft, valueRight, parcode, session)

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));
    
    % Load eye tracking data.
    [~, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    fixItem = cell(data.numBlocks * data.numTestTrials, 1);
    choice = zeros(data.numBlocks * data.numTestTrials, 1);
    valueLeft = zeros(data.numBlocks * data.numTestTrials, 1);
    valueRight = zeros(data.numBlocks * data.numTestTrials, 1);
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            angLeft = data.left{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(angTarget - angLeft);
            angRight = data.right{numBlock}(numTrial);
            valueRight(trial,1) = - abs(angTarget - angRight);
            fixItem{trial,1} = item{numBlock,numTrial};
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            trial = trial + 1;
        end
    end
    fclose('all');
end

countLastFixToChosen = zeros(length(valueDiffs), 1);
countTotal = zeros(length(valueDiffs), 1);

for numTrial=1:length(fixItem)
    for i=length(fixItem{numTrial}):-1:1
        if fixItem{numTrial}(i) == 1 || fixItem{numTrial}(i) == 2
            if fixItem{numTrial}(i) == 1 % fixated left
                valueDiff = valueLeft(numTrial) - valueRight(numTrial);
            elseif fixItem{numTrial}(i) == 2 % fixated right
                valueDiff = valueRight(numTrial) - valueLeft(numTrial);
            end
            idx = find(valueDiffs==valueDiff);

            % Check if choice is the same as last fixated item.
            if ((choice(numTrial) == -1 && fixItem{numTrial}(i) == 1) ...
                    || (choice(numTrial) == 1 && ...
                    fixItem{numTrial}(i) == 2))
                countLastFixToChosen(idx) = countLastFixToChosen(idx) + 1;
            end
            countTotal(idx) = countTotal(idx) + 1;
            break;
        end
    end
end
end
