close all
clear
clc

colors = distinguishable_colors(30);

transparency = 0;

values = 0:1:3;
valueDiffs = -3:1:3;
positiveValueDiffs = 1:1:3;
nonNegativeValueDiffs = 0:1:3;
xLim = [-3.5 3.5];

sessions = 1:4;
parcodes = ['mar'; 'sol'; 'lua'; 'rio'; 'cor'; 'sal'; 'mel'; 'dia'; ...
    'ceu'; 'lei'; 'fio'; 'sul'; 'vai'; 'pai'; 'reu'; 'cai'; 'rei'; ...
    'dor'; 'giz'; 'mae'; 'tia'; 'pia'; 'fui'; 'gol'; 'gel'];

plotsFileBaseName = 'quantile_prob_func';
clocknum = clock;
dateString = [];
for i=1:5
    dateString = [dateString '_' num2str(clocknum(i))];
end
plotsFileName = [plotsFileBaseName dateString];

figure; hold;

% Load all data.
[dataChoice, dataRt, dataValueLeft, dataValueRight, dataFixItem, ...
    dataFixTime, ~, ~] = GetValidDataTrials(parcodes, sessions);
dataValueLeft = (dataValueLeft ./ 5) + 3;
dataValueRight = (dataValueRight ./ 5) + 3;

dataCond = abs(dataValueLeft - dataValueRight);

for cond=positiveValueDiffs
    % Get trial RTs, choices and values for this condition only.
    condRt = dataRt(dataCond==cond);
    condChoice = dataChoice(dataCond==cond);
    condValLeft = dataValueLeft(dataCond==cond);
    condValRight = dataValueRight(dataCond==cond);

    % Get number of trials for this condition.
    condNumTrials = length(condRt);

    % Find which trials were correct.
    correct = zeros(size(condValLeft));
    for i=1:length(condValLeft)
        if condValLeft(i) > condValRight(i)
            if condChoice(i) == -1
                correct(i) = 1;
            end
        elseif condValRight(i) > condValLeft(i)
            if condChoice(i) == 1
                correct(i) = 1;
            end
        else
            correct(i) = 1;
        end
    end
    
    % Get probability of correct and error for this condition.
    condProbCorrect = length(condRt(correct==1)) / condNumTrials;
    condProbError = length(condRt(correct==0)) / condNumTrials;

    % Deal with correct trials.
    correctRt = condRt(correct==1);
    
    % Order trials by RT.
    sortedRt = sort(correctRt);
    
    % Split trials into RT quantile groups.
    count = length(sortedRt);
    lim = floor(count/10);
    
    % Iterate over RT quantile groups.
    quantiles = [0,1,3,5,7,9];
    for q=1:length(quantiles)-1
        lowLim = (quantiles(q) * lim) + 1;
        upLim = (quantiles(q+1) * lim);
        
        % Get only the trials in this RT quantile group.
        quantRtCorrect = sortedRt(lowLim:upLim);
        
        scatter(condProbCorrect, quantRtCorrect(end), ...
            30, 'x', 'MarkerEdgeColor', colors(q,:), 'LineWidth', 2);
    end
    
    % Deal with error trials.
    errorRt = condRt(correct==0);
    
    % Order trials by RT.
    sortedRt = sort(errorRt);
    
    % Split trials into RT quantile groups.
    count = length(sortedRt);
    lim = floor(count/10);
    
    % Iterate over RT quantile groups.
    quantiles = [0,1,3,5,7,9];
    for q=1:length(quantiles)-1
        lowLim = (quantiles(q) * lim) + 1;
        upLim = (quantiles(q+1) * lim);
        
        % Get only the trials in this RT quantile group.
        quantRtError = sortedRt(lowLim:upLim);

        scatter(condProbError, quantRtError(end), ...
            30, 'x', 'MarkerEdgeColor', colors(q,:), 'LineWidth', 2);
    end
end

% Load simulations from the desired model.
[simulChoice, simulRt, simulValueLeft, simulValueRight, simulFixItem, ...
    simulFixTime] = ConvertSimulationsCsvFiles('model3_expdata.csv', ...
    'model3_fixations.csv');

simulCond = abs(simulValueLeft - simulValueRight);

quantRt = {};
quantProb = {};
for i=1:5
    quantRt{i} = [];
    quantProb{i} = [];
end

for cond=positiveValueDiffs
    % Get trial RTs, choices and values for this condition only.
    condRt = simulRt(simulCond==cond);
    condChoice = simulChoice(simulCond==cond);
    condValLeft = simulValueLeft(simulCond==cond);
    condValRight = simulValueRight(simulCond==cond);

    % Get number of trials for this condition.
    condNumTrials = length(condRt);

    % Find which trials were correct.
    correct = zeros(size(condValLeft));
    for i=1:length(condValLeft)
        if condValLeft(i) > condValRight(i)
            if condChoice(i) == -1
                correct(i) = 1;
            end
        elseif condValRight(i) > condValLeft(i)
            if condChoice(i) == 1
                correct(i) = 1;
            end
        else
            correct(i) = 1;
        end
    end
    
    % Get probability of correct and error for this condition.
    condProbCorrect = length(condRt(correct==1)) / condNumTrials;
    condProbError = length(condRt(correct==0)) / condNumTrials;

    % Deal with correct trials.
    correctRt = condRt(correct==1);
    
    % Order trials by RT.
    sortedRt = sort(correctRt);
    
    % Split trials into RT quantile groups.
    count = length(sortedRt);
    lim = floor(count/10);
    
    % Iterate over RT quantile groups.
    quantiles = [0,1,3,5,7,9];
    for q=1:length(quantiles)-1
        lowLim = (quantiles(q) * lim) + 1;
        upLim = (quantiles(q+1) * lim);
        
        % Get only the trials in this RT quantile group.
        quantRtCorrect = sortedRt(lowLim:upLim);
        
        quantRt{q} = [quantRt{q}; quantRtCorrect(end)];
        quantProb{q} = [quantProb{q}; condProbCorrect];
    end
    
    % Deal with error trials.
    errorRt = condRt(correct==0);
    
    % Order trials by RT.
    sortedRt = sort(errorRt);
    
    % Split trials into RT quantile groups.
    count = length(sortedRt);
    lim = floor(count/10);
    
    % Iterate over RT quantile groups.
    quantiles = [0,1,3,5,7,9];
    for q=1:length(quantiles)-1
        lowLim = (quantiles(q) * lim) + 1;
        upLim = (quantiles(q+1) * lim);
        
        % Get only the trials in this RT quantile group.
        quantRtError = sortedRt(lowLim:upLim);

        quantRt{q} = [quantRt{q}; quantRtError(end)];
        quantProb{q} = [quantProb{q}; condProbError];
    end
end

for i=1:5
    [p,idx] = sort(quantProb{i});
    plot(p, quantRt{i}(idx), 'LineStyle', '-', 'Marker', 'o', ...
        'Color', colors(i,:), 'LineWidth', 2);
end

xlim([0 1]);
xlabel('Response proportion','FontSize', 24);
ylabel('RT quantile (ms)','FontSize', 24);
% title('aDDM with \theta=0.36 vs. data','FontSize', 24);
title('aDDM with \theta=1 vs. data','FontSize', 24);
set(gca,'FontSize',20);

orient landscape
print('-dpsc2', '-append', plotsFileName);
