function reactionTimes = ...
    ReactionTimesFromEyetrackerByTrialCondition(parcode, sessn, ...
    orientations)

% Each trial condition corresponds to a particular distance between target
% and left stimulus and a particular distance between target and right
% stimulus.

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

% Read eyetracking data.
[~, ~, ~, ~, trialDuration] = ReadEyetrackingData(parcode, sessn);

% Get reaction times from eye tracker.
reactionTimes = cell(length(orientations), length(orientations));

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        angLeft = data.left{numBlock}(numTrial);
        distLeft = angTarget - angLeft;
        angRight = data.right{numBlock}(numTrial);
        distRight = angTarget - angRight;
        
        row = find(orientations==distLeft);
        col = find(orientations==distRight);
        
        reactionTimes{row,col} = [reactionTimes{row,col}; ...
            trialDuration(numBlock,numTrial)];
    end
end
end
