function reactionTimes = ...
    ReactionTimesFromEyetrackerByValueDiff(valueDiffs, rt, valueLeft, ...
    valueRight, parcode, session, cisOnly, transOnly)

if exist('parcode', 'var') && exist('session', 'var')
    if ~exist('cisOnly', 'var')
        cisOnly = false;
    end
    if ~exist('transOnly', 'var')
        transOnly = false;
    end

    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [~, ~, ~, ~, trialDuration, ~] = ReadEyetrackingData(parcode, session);

    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            distLeft = angTarget - data.left{numBlock}(numTrial);
            distRight = angTarget - data.right{numBlock}(numTrial);
            if distLeft * distRight > 0 && transOnly
                continue;
            end
            if distLeft * distRight < 0 && cisOnly
                continue;
            end
            valueLeft(trial,1) = - abs(distLeft);
            valueRight(trial,1) = - abs(distRight);
            rt(trial,1) = trialDuration(numBlock,numTrial);
            trial = trial + 1;
        end
    end
    fclose('all');
end

reactionTimes = cell(length(valueDiffs), 1);

for numTrial=1:length(rt)
    valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    idx = find(valueDiffs==valueDiff);
    reactionTimes{idx} = [reactionTimes{idx}; rt(numTrial)];
end
end
