function reactionTimes = ReactionTimesGroupedByTargetRecency(parcode, ...
    sessn, recencies)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

reactionTimes = cell(length(recencies), 1);

for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        trialRecency = mod(numTrial-1, length(recencies));
        idx = find(recencies==trialRecency);
        reactionTimes{idx} = [reactionTimes{idx}; ...
            data.testReactionTime{numBlock}(numTrial)];
    end
end
end