function reactionTimes = ReactionTimesGroupedByTrialCondition(parcode, ...
    sessn, orientations)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

reactionTimes = cell(length(orientations), length(orientations));

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        angLeft = data.left{numBlock}(numTrial);
        distLeft = angTarget - angLeft;
        angRight = data.right{numBlock}(numTrial);
        distRight = angTarget - angRight;
        
        row = find(orientations==distLeft);
        col = find(orientations==distRight);
        
        reactionTimes{row,col} = [reactionTimes{row,col}; ...
            data.testReactionTime{numBlock}(numTrial)];
    end
end
end
