function reactionTimes = ReactionTimesGroupedByValueDiff(parcode, ...
    sessn, valueDiffs)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, sessn));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

reactionTimes = cell(length(valueDiffs), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueDiff = valueLeft - valueRight;
        
        idx = find(valueDiffs==valueDiff);
        reactionTimes{idx} = [reactionTimes{idx}; ...
            data.testReactionTime{numBlock}(numTrial)];
    end
end
end
