function reactionTimes = ReactionTimesVsValueBestMinusWorst(valueDiffs, ...
    rt, valueLeft, valueRight, parcode, session, oddTrialsOnly, ...
    evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

     % Read eyetracking data.
    [~, ~, ~, ~, trialDuration, ~] = ReadEyetrackingData(parcode, session);
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            angLeft = data.left{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(angTarget - angLeft);
            angRight = data.right{numBlock}(numTrial);
            valueRight(trial,1) = - abs(angTarget - angRight);
            rt(trial,1) = trialDuration(numBlock,numTrial);
            trial = trial + 1;
        end
    end
    fclose('all');
end

reactionTimes = cell(length(valueDiffs), 1);

for numTrial=1:length(rt)
    if valueLeft(numTrial) >= valueRight(numTrial)
        valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    elseif valueRight(numTrial) > valueLeft(numTrial)
        valueDiff = valueRight(numTrial) - valueLeft(numTrial);
    end
    idx = find(valueDiffs==valueDiff);
    reactionTimes{idx} = [reactionTimes{idx}; rt(numTrial)];
end
end
