function [timeAdvantage, lastFixTime] = ...
    ScatterTimeAdvantageUnfixItemVsLastFixTime(fixItem, fixTime, ...
    choice, parcode, session)

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));
    
    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    fixItem = cell(data.numBlocks * data.numTestTrials, 1);
    fixTime = cell(data.numBlocks * data.numTestTrials, 1);
    choice = zeros(data.numBlocks * data.numTestTrials, 1);
    trial = 1;
    for numBlock = 1:data.numBlocks
        for numTrial = 1:data.numTestTrials
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            trial = trial + 1;
        end
    end
    fclose('all');
end

selectFixTime = cell(length(fixTime), 1);
selectFixItem = cell(length(fixItem), 1);

% Select only fixations to right or left item
for numTrial=1:length(fixItem)
    idx = find(fixItem{numTrial} == 1 | fixItem{numTrial} == 2);
    selectFixTime{numTrial} = fixTime{numTrial}(idx);
    selectFixItem{numTrial} = fixItem{numTrial}(idx);
end

timeAdvantage = [];
lastFixTime = [];

for numTrial=1:length(fixItem)
%     if isempty(selectFixItem{numTrial})
    if length(selectFixItem{numTrial}) < 3
        continue;
    end

    % Use only trials where the last fixation was to the chosen item.
    if (selectFixItem{numTrial}(end) == 1 && choice(numTrial) == 1) || ...
            (selectFixItem{numTrial}(end) == 2 && choice(numTrial) == -1)
        continue;
    end

    if selectFixItem{numTrial}(end) == 1
        lastFixatedItem = 1;
        lastUnfixatedItem = 2;
    elseif selectFixItem{numTrial}(end) == 2
        lastFixatedItem = 2;
        lastUnfixatedItem = 1;
    end
    lastFix = selectFixTime{numTrial}(end);
    lastFixTime = [lastFixTime; lastFix];

    % Iterate all fixations but skip the last one to get time
    % advantage.
    timeFixLastItem = 0;
    timeFixOtherItem = 0;
    for i=1:length(selectFixItem{numTrial})-1
        if selectFixItem{numTrial}(i) == lastFixatedItem
            timeFixLastItem = timeFixLastItem + ...
                selectFixTime{numTrial}(i);
        elseif selectFixItem{numTrial}(i) == lastUnfixatedItem
            timeFixOtherItem = timeFixOtherItem + ...
                selectFixTime{numTrial}(i);
        end
    end
    advantage = timeFixLastItem - timeFixOtherItem;
    timeAdvantage = [timeAdvantage; advantage];
end
end
