function timeAdvantage = TimeAdvantageLeftItemVsValueDiff(valueDiffs, ...
    valueLeft, valueRight, fixItem, fixTime, parcode, session, ...
    oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));
    
    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            distLeft = angTarget - data.left{numBlock}(numTrial);
            distRight = angTarget - data.right{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(distLeft);
            valueRight(trial,1) = - abs(distRight);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

selectFixTime = cell(length(fixTime), 1);
selectFixItem = cell(length(fixItem), 1);

% Select only fixations to right or left item
for numTrial=1:length(fixItem)
    idx = find(fixItem{numTrial} == 1 | fixItem{numTrial} == 2);
    selectFixTime{numTrial} = fixTime{numTrial}(idx);
    selectFixItem{numTrial} = fixItem{numTrial}(idx);
end

timeAdvantage = cell(length(valueDiffs), 1);

for numTrial=1:length(fixItem)
    % Get value differece.
    valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    idx = find(valueDiffs==valueDiff);

    % Get total fixation time for each item.
    timeLeftFix = 0;
    timeRightFix = 0;

    for i = 1:length(fixItem{numTrial})
        if fixItem{numTrial}(i) == 1 % left item fixation
            timeLeftFix = timeLeftFix + fixTime{numTrial}(i);
        elseif fixItem{numTrial}(i) == 2 % right item fixation
            timeRightFix = timeRightFix + fixTime{numTrial}(i);
        end
    end

    % Get time advantage.
    timeDiff = timeLeftFix - timeRightFix;
    timeAdvantage{idx} = [timeAdvantage{idx}; timeDiff];
end
end
