function [trialCountChoseFixed, trialCountChoseUnfixed] = ...
    TrialCountByChoiceAndValueDiff(valueDiffs, choice, fixItem, ...
    valueLeft, valueRight, parcode, session)

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [~, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    fixItem = cell(data.numBlocks * data.numTestTrials, 1);
    choice = zeros(data.numBlocks * data.numTestTrials, 1);
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            angLeft = data.left{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(angTarget - angLeft);
            angRight = data.right{numBlock}(numTrial);
            valueRight(trial,1) = - abs(angTarget - angRight);
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

selectFixItem = cell(length(fixItem),1);

% Select only fixations to right or left item.
for numTrial=1:length(fixItem)
    idx = find(fixItem{numTrial} == 1 | fixItem{numTrial} == 2);
    selectFixItem{numTrial} = fixItem{numTrial}(idx);
end

trialCountChoseFixed = zeros(length(valueDiffs), 1);
trialCountChoseUnfixed = zeros(length(valueDiffs), 1);

for numTrial=1:length(selectFixItem)
    if length(selectFixItem{numTrial}) <= 1
        continue;
    end
    valueDiff = abs(valueLeft(numTrial) - valueRight(numTrial));
    idx = find(valueDiffs==valueDiff);

    % Choice was left.
    if choice(numTrial) == -1
        % Last fixation was left.
        if selectFixItem{numTrial}(end) == 1
            trialCountChoseFixed(idx) = trialCountChoseFixed(idx) + 1;
        % Last fixation was right.
        elseif selectFixItem{numTrial}(end) == 2
            trialCountChoseUnfixed(idx) = trialCountChoseUnfixed(idx) + 1;
        end
    % Choice was right.
    elseif choice(numTrial) == 1
        % Last fixation was left.
        if selectFixItem{numTrial}(end) == 1
            trialCountChoseUnfixed(idx) = trialCountChoseUnfixed(idx) + 1;
        % Last fixation was right.
        elseif selectFixItem{numTrial}(end) == 2
            trialCountChoseFixed(idx) = trialCountChoseFixed(idx) + 1;
        end
    end
end
end
