function [valueDiff, firstFixDuration] = ...
    ValueDifferenceVsFirstFixDuration(fixItem, fixTime, valueLeft, ...
    valueRight, parcode, session, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    valueLeft = [];
    valueRight = [];
    fixItem = {};
    fixTime = {};
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            distLeft = angTarget - data.left{numBlock}(numTrial);
            distRight = angTarget - data.right{numBlock}(numTrial);
            if distLeft * distRight > 0
                continue;
            end
            if distLeft * distRight < 0
                continue;
            end
            valueLeft(trial,1) = - abs(distLeft);
            valueRight(trial,1) = - abs(distRight);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

valueDiff = zeros(length(valueLeft), 1);
firstFixDuration = zeros(length(valueLeft), 1);

for trial=1:length(valueLeft)
    timeFirstFix = 0;
    firstFixItem = 0;
    for i = 1:length(fixItem{trial})
        if fixItem{trial}(i) == 1 % left item fixation
            timeFirstFix = fixTime{trial}(i);
            firstFixItem = 1;
            break;
        elseif fixItem{trial}(i) == 2 % right item fixation
            timeFirstFix = fixTime{trial}(i);
            firstFixItem = 2;
            break;
        end
    end

    % Get duration of first fixated item.
    firstFixDuration(trial) = timeFirstFix;
    
    % Get value difference.
    if firstFixItem == 1 % 1st fix left
        valueDiff(trial) = valueLeft(trial) - valueRight(trial);
    elseif firstFixItem == 2 % 1st fix right 
        valueDiff(trial) = valueRight(trial) - valueLeft(trial);
    end
end
end