function [valueDiff, timeAdvantageLeft] = ...
    ValueDifferenceVsTimeAdvantageLeft(choice, fixItem, fixTime, ...
    valueLeft, valueRight, parcode, session, oddTrialsOnly, evenTrialsOnly)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [time, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

    valueLeft = [];
    valueRight = [];
    choice = [];
    fixItem = {};
    fixTime = {};
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            if mod(numTrial,2) == 0 && oddTrialsOnly
                continue;
            end
            if mod(numTrial,2) == 1 && evenTrialsOnly
                continue;
            end
            distLeft = angTarget - data.left{numBlock}(numTrial);
            distRight = angTarget - data.right{numBlock}(numTrial);
            if distLeft * distRight > 0
                continue;
            end
            if distLeft * distRight < 0
                continue;
            end
            valueLeft(trial,1) = - abs(distLeft);
            valueRight(trial,1) = - abs(distRight);
            choice(trial,1) = data.testResponseType{numBlock}(numTrial);
            fixItem{trial,1} = item{numBlock,numTrial};
            fixTime{trial,1} = time{numBlock,numTrial};
            trial = trial + 1;
        end
    end
    fclose('all');
end

% Get value difference.
valueDiff = valueLeft - valueRight;

timeAdvantageLeft = zeros(length(choice), 1);

for trial=1:length(choice)
    % Get total fixation time for each item.
    timeLeftFix = 0;
    timeRightFix = 0;

    for i = 1:length(fixItem{trial})
        if fixItem{trial}(i) == 1 % left item fixation
            timeLeftFix = timeLeftFix + fixTime{trial}(i);
        elseif fixItem{trial}(i) == 2 % right item fixation
            timeRightFix = timeRightFix + fixTime{trial}(i);
        end
    end

    % Get time advantage of left item.
    timeAdvantageLeft(trial) = timeLeftFix - timeRightFix;
end
end