function [countDecisions, countLeftChosen] = Choices(valueDiffs, ...
    parcode, session)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));

valueLeft = zeros(data.numBlocks * data.numTestTrials, 1);
valueRight = zeros(data.numBlocks * data.numTestTrials, 1);
choice = zeros(data.numBlocks * data.numTestTrials, 1);
time = zeros(data.numBlocks * data.numTestTrials, 1);
trial = 1;
for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        angLeft = data.left{numBlock}(numTrial);
        valueLeft(trial,1) = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight(trial,1) = - abs(angTarget - angRight);
        choice(trial,1) = data.testResponseType{numBlock}(numTrial);
        time(trial,1) = data.testTotalFixTime{numBlock}(numTrial);
        trial = trial + 1;
    end
end
fclose('all');

countDecisions = zeros(length(valueDiffs), 1);
countLeftChosen = zeros(length(valueDiffs), 1);

for numTrial=1:length(choice)
    valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    idx = find(valueDiffs==valueDiff);

    if time(numTrial) >= 3
        continue;
    end
    countDecisions(idx) = countDecisions(idx) + 1;
    if choice(numTrial) == -1 % chose left
        countLeftChosen(idx) = countLeftChosen(idx) + 1;
    end
end
end
