function [countDecisionsLeftBiased, countLeftChosenLeftBiased, ...
    countDecisionsRightBiased, countLeftChosenRightBiased] = ...
    ChoicesGroupedByBiased(valueDiffs, parcode, session)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

countDecisionsLeftBiased = zeros(length(valueDiffs), 1);
countLeftChosenLeftBiased = zeros(length(valueDiffs), 1);
countDecisionsRightBiased = zeros(length(valueDiffs), 1);
countLeftChosenRightBiased = zeros(length(valueDiffs), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        if data.testTotalFixTime{numBlock}(numTrial) >= 3
            continue;
        end
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueDiff = valueLeft - valueRight;
        idx = find(valueDiffs==valueDiff);

        % Left was biased.
        if data.biasedItem{numBlock}(numTrial) == 1
            countDecisionsLeftBiased(idx) = ...
                countDecisionsLeftBiased(idx) + 1;
            if data.testResponseType{numBlock}(numTrial) == -1 % chose left
                countLeftChosenLeftBiased(idx) = ...
                    countLeftChosenLeftBiased(idx) + 1;
            end
        % Right was biased.
        elseif data.biasedItem{numBlock}(numTrial) == 2
            countDecisionsRightBiased(idx) = ...
                countDecisionsRightBiased(idx) + 1;
            if data.testResponseType{numBlock}(numTrial) == -1 % chose left
                countLeftChosenRightBiased(idx) = ...
                    countLeftChosenRightBiased(idx) + 1;
            end
        end
    end
end
end
